/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.FileComparator;
import org.infoglue.deliver.util.MathHelper;

public class ViewLoggingAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewLoggingAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String logFragment = "";
    private int logLines = 50;
    private List logFiles = new ArrayList();
    private String logFileName = null;

    public String doExecute() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase == null || catalinaBase.equals("")) {
            catalinaBase = CmsPropertyHandler.getContextRootPath().substring(0, CmsPropertyHandler.getContextRootPath().lastIndexOf("/"));
        }
        catalinaBase = String.valueOf(catalinaBase) + File.separator + "logs";
        String velocityLog = String.valueOf(CmsPropertyHandler.getContextRootPath()) + File.separator + "velocity.log";
        List<File> fileList = Arrays.asList(new File(catalinaBase).listFiles());
        this.logFiles.addAll(fileList);
        List<File> debugFileList = Arrays.asList(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + File.separator + "logs").listFiles());
        this.logFiles.addAll(debugFileList);
        File velocityLogFile = new File(velocityLog);
        if (velocityLogFile.exists()) {
            this.logFiles.add(velocityLogFile);
        }
        String fileName = "";
        if (this.logFileName == null || this.logFileName.equals("")) {
            if (this.logFiles.size() > 0) {
                fileName = ((File)this.logFiles.get(0)).getPath();
                for (File file : this.logFiles) {
                    if (!file.getName().equals("catalina.out")) continue;
                    fileName = file.getPath();
                    break;
                }
            }
        } else {
            fileName = "An invalid file requested - could be an hack attempt:" + this.logFileName;
            for (File file : this.logFiles) {
                if (!file.getPath().equals(this.logFileName)) continue;
                fileName = this.logFileName;
                break;
            }
        }
        if (this.logFiles != null && this.logFiles.size() > 0) {
            Collections.sort(this.logFiles, Collections.reverseOrder(new FileComparator("lastModified")));
        }
        File file = new File(fileName);
        this.logFragment = FileHelper.tail(file, this.logLines);
        return "success";
    }

    public String getLogFragment() {
        return this.logFragment;
    }

    public List getLogFiles() {
        return this.logFiles;
    }

    public int getLogLines() {
        return this.logLines;
    }

    public void setLogLines(int logLines) {
        this.logLines = logLines;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getLastModifiedDateString(long lastModified) {
        Date date = new Date(lastModified);
        String lastModifiedDateString = new VisualFormatter().formatDate(date, "yy-MM-dd HH:ss");
        return lastModifiedDateString;
    }

    public String getFileSize(long size) {
        String fileSize = new MathHelper().fileSize(size);
        return fileSize;
    }
}

