/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class ViewListSystemUserAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private List infogluePrincipals;
    private String mode = null;
    private String filterUserName = null;
    private String filterFirstName = null;
    private String filterLastName = null;
    private String filterEmail = null;
    private String[] filterRoleNames = null;
    private int slotId = 0;
    private int numberOfSlots = 0;

    protected String doExecute() throws Exception {
        this.filterRoleNames = this.getRequest().getParameterValues("filterRoleName");
        if (this.filterFirstName == null && this.filterLastName == null && this.filterUserName == null && this.filterEmail == null && (this.filterRoleNames == null || this.filterRoleNames.length == 0 || this.filterRoleNames.length == 1 && this.filterRoleNames[0].equals(""))) {
            this.infogluePrincipals = UserControllerProxy.getController().getAllUsers();
            this.numberOfSlots = this.infogluePrincipals.size() / 100;
            int startIndex = 0 + this.slotId * 100;
            int endIndex = 0 + this.slotId * 100 + 100;
            if (endIndex > this.infogluePrincipals.size()) {
                endIndex = this.infogluePrincipals.size();
            }
            this.infogluePrincipals = this.infogluePrincipals.subList(startIndex, endIndex);
        } else {
            this.infogluePrincipals = UserControllerProxy.getController().getFilteredUsers(this.filterFirstName, this.filterLastName, this.filterUserName, this.filterEmail, this.filterRoleNames);
        }
        return "success";
    }

    public String doV3() throws Exception {
        this.filterRoleNames = this.getRequest().getParameterValues("filterRoleName");
        if (this.filterFirstName == null && this.filterLastName == null && this.filterUserName == null && this.filterEmail == null && (this.filterRoleNames == null || this.filterRoleNames.length == 0 || this.filterRoleNames.length == 1 && this.filterRoleNames[0].equals(""))) {
            this.infogluePrincipals = UserControllerProxy.getController().getAllUsers();
            this.numberOfSlots = this.infogluePrincipals.size() / 100;
            int startIndex = 0 + this.slotId * 100;
            int endIndex = 0 + this.slotId * 100 + 100;
            if (endIndex > this.infogluePrincipals.size()) {
                endIndex = this.infogluePrincipals.size();
            }
            this.infogluePrincipals = this.infogluePrincipals.subList(startIndex, endIndex);
        } else {
            this.infogluePrincipals = UserControllerProxy.getController().getFilteredUsers(this.filterFirstName, this.filterLastName, this.filterUserName, this.filterEmail, this.filterRoleNames);
        }
        return "successV3";
    }

    public String doUserListForPopup() throws Exception {
        this.infogluePrincipals = UserControllerProxy.getController().getAllUsers();
        Collections.sort(this.infogluePrincipals, new ReflectionComparator("firstName"));
        return "successPopup";
    }

    public String doUserListSearch() throws Exception {
        String searchString = this.getRequest().getParameter("searchString");
        List searchResult = UserControllerProxy.getController().getFilteredUsers(searchString, null, null, null, null);
        ServletOutputStream myOut = this.getResponse().getOutputStream();
        myOut.print("<select name=\"searchResult\" size=\"10\" class=\"userSelectBox\" multiple=\"true\">");
        for (InfoGluePrincipal igp : searchResult) {
            myOut.print("<option value=\"" + igp.getName() + "\">" + igp.getFirstName() + " " + igp.getLastName() + "</option>");
        }
        myOut.print("</select>");
        return "none";
    }

    public List getRoles() throws Exception {
        List roles = RoleControllerProxy.getController().getAllRoles();
        return roles;
    }

    public List getInfogluePrincipals() {
        return this.infogluePrincipals;
    }

    public String getFilterEmail() {
        return this.filterEmail;
    }

    public void setFilterEmail(String email) {
        if (email != null && !email.equals("")) {
            this.filterEmail = email;
        }
    }

    public String getFilterFirstName() {
        return this.filterFirstName;
    }

    public void setFilterFirstName(String firstName) {
        if (firstName != null && !firstName.equals("")) {
            this.filterFirstName = firstName;
        }
    }

    public String getFilterLastName() {
        return this.filterLastName;
    }

    public void setFilterLastName(String lastName) {
        if (lastName != null && !lastName.equals("")) {
            this.filterLastName = lastName;
        }
    }

    public String getFilterUserName() {
        return this.filterUserName;
    }

    public void setFilterUserName(String userName) {
        if (userName != null && !userName.equals("")) {
            this.filterUserName = userName;
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String[] getFilterRoleNames() {
        return this.filterRoleNames;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public void setSlotId(int slotId) {
        this.slotId = slotId;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }
}

