/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.managementtool.actions.ViewEntityPropertiesAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.GroupPropertiesVO;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewGroupPropertiesAction
extends ViewEntityPropertiesAction {
    private static final Logger logger = Logger.getLogger((String)ViewGroupPropertiesAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String groupName;
    private GroupPropertiesVO groupPropertiesVO;
    private List groupPropertiesVOList;

    protected void initialize(String groupName) throws Exception {
        super.initialize();
        logger.info((Object)("groupName:" + groupName));
        List contentTypeDefinitionVOList = GroupPropertiesController.getController().getContentTypeDefinitionVOList(groupName);
        if (contentTypeDefinitionVOList != null && contentTypeDefinitionVOList.size() > 0) {
            this.setContentTypeDefinitionVO((ContentTypeDefinitionVO)contentTypeDefinitionVOList.get(0));
        }
        InfoGlueGroup infoGlueGroup = GroupControllerProxy.getController().getGroup(groupName);
        this.groupPropertiesVOList = GroupPropertiesController.getController().getGroupPropertiesVOList(groupName, this.getLanguageId());
        if (this.groupPropertiesVOList != null && this.groupPropertiesVOList.size() > 0) {
            this.groupPropertiesVO = (GroupPropertiesVO)this.groupPropertiesVOList.get(0);
            this.setContentTypeDefinitionId(this.groupPropertiesVO.getContentTypeDefinitionId());
        } else {
            this.setContentTypeDefinitionId(this.getContentTypeDefinitionVO().getContentTypeDefinitionId());
        }
        logger.info((Object)("this.groupPropertiesVO:" + this.groupPropertiesVO));
        this.setAttributes(ContentTypeDefinitionController.getController().getContentTypeAttributes(this.getContentTypeDefinitionVO().getSchemaValue()));
        logger.info((Object)("attributes:" + this.getContentTypeAttributes().size()));
        logger.info((Object)("availableLanguages:" + this.getAvailableLanguages().size()));
    }

    public String doExecute() throws Exception {
        this.initialize(this.getGroupName());
        this.setCurrentAction("ViewGroupProperties.action");
        this.setUpdateAction("UpdateGroupProperties");
        this.setUpdateAndExitAction("UpdateGroupProperties!saveAndExit");
        this.setCancelAction("ViewGroup.action");
        this.setToolbarKey("tool.managementtool.viewGroupProperties.header");
        this.setTitleKey("tool.managementtool.viewGroupProperties.header");
        this.setArguments("");
        this.setEntityName(GroupProperties.class.getName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getGroupName());
        this.setCurrentAction("ViewGroupProperties!v3.action");
        this.setUpdateAction("UpdateGroupProperties!v3");
        this.setUpdateAndExitAction("UpdateGroupProperties!saveAndExitV3");
        this.setCancelAction("ViewGroup!v3.action");
        this.setToolbarKey("tool.managementtool.viewGroupProperties.header");
        this.setTitleKey("tool.managementtool.viewGroupProperties.header");
        this.setArguments("");
        this.setEntityName(GroupProperties.class.getName());
        return "successV3";
    }

    public List getDigitalAssets() {
        List digitalAssets = null;
        try {
            if (this.groupPropertiesVO != null && this.groupPropertiesVO.getId() != null) {
                digitalAssets = GroupPropertiesController.getController().getDigitalAssetVOList(this.groupPropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public List getRelatedCategories(String attribute) {
        try {
            if (this.groupPropertiesVO != null && this.groupPropertiesVO.getId() != null) {
                return this.getPropertiesCategoryController().findByPropertiesAttribute(attribute, GroupProperties.class.getName(), this.groupPropertiesVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public String getXML() {
        return this.groupPropertiesVO == null ? null : this.groupPropertiesVO.getValue();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GroupPropertiesVO getGroupPropertiesVO() {
        return this.groupPropertiesVO;
    }

    public List getGroupPropertiesVOList() {
        return this.groupPropertiesVOList;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.setOwnerEntityId(groupName);
    }

    public Integer getEntityId() {
        return this.groupPropertiesVO.getId();
    }

    public void setOwnerEntityId(String ownerEntityId) {
        super.setOwnerEntityId(ownerEntityId);
        this.groupName = ownerEntityId;
    }

    public String getReturnAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCurrentAction()) + "?groupName=" + URLEncoder.encode(this.groupName, URIEncoding) + "&amp;languageId=" + this.getLanguageId();
    }

    public String getCancelAddress() throws Exception {
        String URIEncoding = CmsPropertyHandler.getURIEncoding();
        return String.valueOf(this.getCancelAction()) + "?groupName=" + URLEncoder.encode(this.groupName, URIEncoding);
    }
}

