/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.security.InfoGlueGroup;

public class ViewGroupAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private String groupName;
    private boolean supportsUpdate = true;
    private InfoGlueGroup infoGlueGroup;
    private List infoGluePrincipals = new ArrayList();
    private List assignedInfoGluePrincipals;
    private List contentTypeDefinitionVOList;
    private List assignedContentTypeDefinitionVOList;

    protected void initialize(String groupName) throws Exception {
        this.infoGlueGroup = GroupControllerProxy.getController().getGroup(groupName);
        this.supportsUpdate = this.infoGlueGroup.getAutorizationModule().getSupportUpdate();
        this.assignedInfoGluePrincipals = this.infoGlueGroup.getAutorizationModule().getGroupUsers(groupName);
        if (this.supportsUpdate) {
            this.infoGluePrincipals = this.infoGlueGroup.getAutorizationModule().getUsers();
        }
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_GROUP_PROPERTIES);
        this.assignedContentTypeDefinitionVOList = GroupPropertiesController.getController().getContentTypeDefinitionVOList(groupName);
    }

    public String doExecute() throws Exception {
        this.initialize(this.getGroupName());
        return "success";
    }

    public String doV3() throws Exception {
        this.initialize(this.getGroupName());
        return "successV3";
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getDescription() {
        return this.infoGlueGroup.getDescription();
    }

    public List getAllInfoGluePrincipals() throws Exception {
        return this.infoGluePrincipals;
    }

    public List getAssignedInfoGluePrincipals() throws Exception {
        return this.assignedInfoGluePrincipals;
    }

    public List getAssignedContentTypeDefinitionVOList() {
        return this.assignedContentTypeDefinitionVOList;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public void setAssignedContentTypeDefinitionVOList(List list) {
        this.assignedContentTypeDefinitionVOList = list;
    }

    public void setContentTypeDefinitionVOList(List list) {
        this.contentTypeDefinitionVOList = list;
    }

    public boolean getSupportsUpdate() {
        return this.supportsUpdate;
    }
}

