/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PropertiesCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.dom.DOMBuilder;

public abstract class ViewEntityPropertiesAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewEntityPropertiesAction.class.getName());
    private static CategoryController categoryController = CategoryController.getController();
    private static PropertiesCategoryController propertiesCategoryController = PropertiesCategoryController.getController();
    private String currentAction = "";
    private String updateAction = "";
    private String updateAndExitAction = "";
    private String cancelAction = "";
    private String toolbarKey = "";
    private String titleKey = "";
    private String arguments = "";
    private String entityName = null;
    private Integer entityId = null;
    private String ownerEntityName = null;
    private String ownerEntityId = null;
    private List availableLanguages;
    private List contentTypeDefinitionVOList;
    private List contentTypeAttributes;
    private Integer contentTypeDefinitionId;
    private Integer languageId;
    private String attributeName = "";
    private String textAreaId = "";
    private ContentTypeDefinitionVO contentTypeDefinitionVO;

    public abstract String getXML();

    public abstract String getCancelAddress() throws Exception;

    public abstract String getReturnAddress() throws Exception;

    public void initialize() throws SystemException, Bug {
        this.setAvailableLanguages(LanguageController.getController().getLanguageVOList());
        if (this.getLanguageId() == null && this.getAvailableLanguages().size() > 0) {
            this.setLanguageId(((LanguageVO)this.getAvailableLanguages().get(0)).getLanguageId());
        }
        logger.info((Object)("Language:" + this.languageId));
    }

    public String getAttributeValue(String key) {
        String value = "";
        try {
            DOMBuilder domBuilder;
            Document document;
            Node node;
            String xml = this.getXML();
            if (xml != null && (node = (document = (domBuilder = new DOMBuilder()).getDocument(xml)).getRootElement().selectSingleNode("attributes/" + key)) != null && (value = node.getStringValue()) != null) {
                value = new VisualFormatter().escapeHTML(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getUnescapedAttributeValue(String key) {
        String value = "";
        try {
            String xml = this.getXML();
            int startTagIndex = xml.indexOf("<" + key + ">");
            int endTagIndex = xml.indexOf("]]></" + key + ">");
            if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getDigitalAssetUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getQualifyerPath(String entity, String entityId) {
        StringBuffer sb = new StringBuffer("");
        try {
            if (entity.equalsIgnoreCase("Content")) {
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(entityId));
                sb.insert(0, String.valueOf(contentVO.getName()) + "/");
                while (contentVO.getParentContentId() != null) {
                    contentVO = ContentController.getContentController().getContentVOWithId(contentVO.getParentContentId());
                    sb.insert(0, String.valueOf(contentVO.getName()) + "/");
                }
            } else if (entity.equalsIgnoreCase("SiteNode")) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(new Integer(entityId));
                sb.insert(0, String.valueOf(siteNodeVO.getName()) + "/");
                while (siteNodeVO.getParentSiteNodeId() != null) {
                    siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeVO.getParentSiteNodeId());
                    sb.insert(0, String.valueOf(siteNodeVO.getName()) + "/");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public List getContentRelationQualifyers(String qualifyerXML) {
        logger.info((Object)("Content qualifyerXML:" + qualifyerXML));
        return this.parseQualifyersFromXML(qualifyerXML, "contentId");
    }

    public List getSiteNodeRelationQualifyers(String qualifyerXML) {
        logger.info((Object)("Content qualifyerXML:" + qualifyerXML));
        return this.parseQualifyersFromXML(qualifyerXML, "siteNodeId");
    }

    private List parseQualifyersFromXML(String qualifyerXML, String currentEntityIdentifyer) {
        ArrayList<QualifyerVO> qualifyers = new ArrayList<QualifyerVO>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return qualifyers;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (Element child : children) {
                String id = child.getStringValue();
                QualifyerVO qualifyerVO = new QualifyerVO();
                qualifyerVO.setName(currentEntityIdentifyer);
                qualifyerVO.setValue(id);
                qualifyerVO.setPath(this.getQualifyerPath(entity, id));
                qualifyers.add(qualifyerVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qualifyers;
    }

    public List getDefinedCategoryKeys() {
        try {
            if (this.getContentTypeDefinitionVO() != null) {
                return ContentTypeDefinitionController.getController().getDefinedCategoryKeys(this.getContentTypeDefinitionVO().getSchemaValue());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public List getAvailableCategories(Integer categoryId) {
        try {
            String protectCategories = CmsPropertyHandler.getProtectCategories();
            if (protectCategories != null && protectCategories.equalsIgnoreCase("true")) {
                return this.getCategoryController().getAuthorizedActiveChildren(categoryId, this.getInfoGluePrincipal());
            }
            return this.getCategoryController().findAllActiveChildren(categoryId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of categories: " + e.getMessage()), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public CategoryController getCategoryController() {
        return categoryController;
    }

    public PropertiesCategoryController getPropertiesCategoryController() {
        return propertiesCategoryController;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public String getToolbarKey() {
        return this.toolbarKey;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(String currentAction) {
        this.currentAction = currentAction;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public String getUpdateAndExitAction() {
        return this.updateAndExitAction;
    }

    public void setUpdateAndExitAction(String updateAndExitAction) {
        this.updateAndExitAction = updateAndExitAction;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setToolbarKey(String toolbarKey) {
        this.toolbarKey = toolbarKey;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public String getOwnerEntityId() {
        return this.ownerEntityId;
    }

    public void setOwnerEntityId(String ownerEntityId) {
        this.ownerEntityId = ownerEntityId;
    }

    public String getOwnerEntityName() {
        return this.ownerEntityName;
    }

    public void setOwnerEntityName(String ownerEntityName) {
        this.ownerEntityName = ownerEntityName;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public void setAvailableLanguages(List availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }

    public void setContentTypeDefinitionVO(ContentTypeDefinitionVO contentTypeDefinitionVO) {
        this.contentTypeDefinitionVO = contentTypeDefinitionVO;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public void setContentTypeDefinitionVOList(List contentTypeDefinitionVOList) {
        this.contentTypeDefinitionVOList = contentTypeDefinitionVOList;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getTextAreaId() {
        return this.textAreaId;
    }

    public void setTextAreaId(String textAreaId) {
        this.textAreaId = textAreaId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public List getContentTypeAttributes() {
        return this.contentTypeAttributes;
    }

    public void setAttributes(List contentTypeAttributes) {
        this.contentTypeAttributes = contentTypeAttributes;
    }

    public String getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(String cancelAction) {
        this.cancelAction = cancelAction;
    }
}

