/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.CategoryAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ViewContentTypeDefinitionAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentTypeDefinitionAction.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String USE_EDITOR = "useEditor";
    private static CategoryController categoryController = CategoryController.getController();
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private String currentContentTypeEditorViewLanguageCode;
    private List attributes = null;
    private List availableLanguages = null;
    private List languageVOList;
    private String title;
    private String inputTypeId;
    private String attributeName;
    private String newAttributeName;
    private String attributeParameterId;
    private String attributeParameterValueId;
    private String newAttributeParameterValueId;
    private String attributeParameterValueLabel;
    private String attributeParameterValueLocale;
    private String attributeToExpand;
    private String assetKey;
    private String newAssetKey;
    private String categoryKey;
    private String newCategoryKey;
    private Boolean isMandatory = new Boolean(false);
    private String description = "";
    private Integer maximumSize;
    private String allowedContentTypes = "any";
    private String imageWidth;
    private String imageHeight;
    private String assetUploadTransformationsSettings = "";
    private List activatedName = new ArrayList();

    public ViewContentTypeDefinitionAction() {
        this(new ContentTypeDefinitionVO());
    }

    public ViewContentTypeDefinitionAction(ContentTypeDefinitionVO contentTypeDefinitionVO) {
        this.contentTypeDefinitionVO = contentTypeDefinitionVO;
    }

    protected void initialize(Integer contentTypeDefinitionId) throws Exception {
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentTypeDefinitionId);
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().validateAndUpdateContentType(this.contentTypeDefinitionVO);
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentTypeDefinitionId);
        this.attributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
        this.availableLanguages = LanguageController.getController().getLanguageVOList();
    }

    public String doExecute() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUseEditor() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUseSimple() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        return "success";
    }

    public String doInsertAttribute() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        String newSchemaValue = ContentTypeDefinitionController.getController().insertContentTypeAttribute(this.contentTypeDefinitionVO.getSchemaValue(), this.inputTypeId, this.activatedName);
        this.contentTypeDefinitionVO.setSchemaValue(newSchemaValue);
        ContentTypeDefinitionController.getController().update(this.contentTypeDefinitionVO);
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doDeleteAttribute() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                element.getParentNode().removeChild(element);
            }
            String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@property = '" + this.attributeName + "']";
            NodeList anl2 = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)validatorsXPath);
            int i = 0;
            while (i < anl2.getLength()) {
                Element element = (Element)anl2.item(i);
                element.getParentNode().removeChild(element);
                ++i;
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doMoveAttributeUp() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            Element previousElement = null;
            int i = 0;
            while (i < anl.getLength()) {
                Element element = (Element)anl.item(i);
                if (element.getAttribute("name").equalsIgnoreCase(this.attributeName) && previousElement != null) {
                    Element parent = (Element)element.getParentNode();
                    parent.removeChild(element);
                    parent.insertBefore(element, previousElement);
                }
                previousElement = element;
                ++i;
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doMoveAttributeDown() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            Node parent = null;
            Element elementToMove = null;
            boolean isInserted = false;
            int position = 0;
            int i = 0;
            while (i < anl.getLength()) {
                Element element = (Element)anl.item(i);
                parent = (Element)element.getParentNode();
                if (elementToMove != null) {
                    if (position == 2) {
                        parent.insertBefore(elementToMove, element);
                        isInserted = true;
                        break;
                    }
                    ++position;
                }
                if (element.getAttribute("name").equalsIgnoreCase(this.attributeName)) {
                    elementToMove = element;
                    parent.removeChild(elementToMove);
                    ++position;
                }
                ++i;
            }
            if (!isInserted && elementToMove != null) {
                parent.appendChild(elementToMove);
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doMoveAssetKeyUp() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:simpleType[@name = 'assetKeys']/xs:restriction/xs:enumeration[@value='" + this.assetKey + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                Node parentElement = element.getParentNode();
                Node previuosSibling = element.getPreviousSibling();
                if (previuosSibling != null) {
                    parentElement.removeChild(element);
                    parentElement.insertBefore(element, previuosSibling);
                }
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doMoveAssetKeyDown() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:simpleType[@name = 'assetKeys']/xs:restriction/xs:enumeration[@value='" + this.assetKey + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                Node parentElement = element.getParentNode();
                Node nextSibling = element.getNextSibling();
                if (nextSibling != null) {
                    parentElement.removeChild(nextSibling);
                    parentElement.insertBefore(nextSibling, element);
                }
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doDeleteAttributeParameterValue() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']/xs:annotation/xs:appinfo/params/param[@id='" + this.attributeParameterId + "']/values/value[@id='" + this.attributeParameterValueId + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                element.getParentNode().removeChild(element);
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doInsertAttributeParameterValue() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']/xs:annotation/xs:appinfo/params/param[@id='" + this.attributeParameterId + "']/values";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                Element newValue = document.createElement("value");
                newValue.setAttribute("id", this.getRandomName());
                newValue.setAttribute("label", this.getRandomName());
                element.appendChild(newValue);
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUpdateAttribute() throws Exception {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        if (this.newAttributeName.indexOf(" ") > -1 || this.newAttributeName.indexOf(".") > -1 || this.newAttributeName.indexOf("'") > -1 || this.newAttributeName.indexOf("\"") > -1) {
            ceb.add(new ConstraintException("ContentTypeAttribute.updateAction", "3500"));
        }
        ceb.throwIfNotEmpty();
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String[] extraParameterNames = this.getRequest().getParameterValues("parameterNames");
            if (extraParameterNames != null) {
                int i = 0;
                while (i < extraParameterNames.length) {
                    String extraParameterName = extraParameterNames[i];
                    String value = this.getRequest().getParameter(extraParameterName);
                    String extraParametersXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']/xs:annotation/xs:appinfo/params/param[@id='" + extraParameterName + "']/values/value";
                    NodeList extraParamsNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)extraParametersXPath);
                    if (extraParamsNodeList != null && extraParamsNodeList.getLength() > 0) {
                        Element element = (Element)extraParamsNodeList.item(0);
                        if (extraParameterName.equalsIgnoreCase("values") && (this.inputTypeId.equalsIgnoreCase("select") || this.inputTypeId.equalsIgnoreCase("checkbox") || this.inputTypeId.equalsIgnoreCase("radiobutton"))) {
                            ((Element)element.getParentNode().getParentNode()).setAttribute("inputTypeId", "1");
                        } else if (extraParameterName.equalsIgnoreCase("Markup") && this.inputTypeId.equalsIgnoreCase("customfield")) {
                            ((Element)element.getParentNode().getParentNode()).setAttribute("inputTypeId", "2");
                        } else {
                            ((Element)element.getParentNode().getParentNode()).setAttribute("inputTypeId", "0");
                        }
                        String inputTypeId = ((Element)element.getParentNode().getParentNode()).getAttribute("inputTypeId");
                        if (inputTypeId.equals("0") || inputTypeId.equals("2")) {
                            if (this.currentContentTypeEditorViewLanguageCode != null && this.currentContentTypeEditorViewLanguageCode.length() > 0) {
                                element.setAttribute("label_" + this.currentContentTypeEditorViewLanguageCode, value);
                            } else {
                                element.setAttribute("label", value);
                            }
                        }
                    }
                    ++i;
                }
            }
            String attributeXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributeXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                element.setAttribute("name", this.newAttributeName);
                element.setAttribute("type", this.inputTypeId);
            }
            try {
                String validationXPath = "//xs:complexType[@name='Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@property='" + this.attributeName + "']";
                NodeList fieldNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)validationXPath);
                if (fieldNodeList != null && fieldNodeList.getLength() > 0) {
                    Element element = (Element)fieldNodeList.item(0);
                    element.setAttribute("property", this.newAttributeName);
                }
                String validationDependentXPath = "//xs:complexType[@name='Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@depends='requiredif']/var/var-value";
                NodeList requiredIfValueNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)validationDependentXPath);
                if (requiredIfValueNodeList != null && requiredIfValueNodeList.getLength() > 0) {
                    int i = 0;
                    while (i < requiredIfValueNodeList.getLength()) {
                        Element element = (Element)requiredIfValueNodeList.item(0);
                        if (element.getFirstChild() != null && element.getFirstChild().getNodeValue() != null && element.getFirstChild().getNodeValue().equals(this.attributeName)) {
                            element.getFirstChild().setNodeValue(this.newAttributeName);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ve) {
                ve.printStackTrace();
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUpdateAttributeParameterValue() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String parameterValueXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + this.attributeName + "']/xs:annotation/xs:appinfo/params/param[@id='" + this.attributeParameterId + "']/values/value[@id='" + this.attributeParameterValueId + "']";
            NodeList parameterValuesNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)parameterValueXPath);
            if (parameterValuesNodeList != null && parameterValuesNodeList.getLength() > 0) {
                Element element = (Element)parameterValuesNodeList.item(0);
                element.setAttribute("id", this.newAttributeParameterValueId);
                if (this.currentContentTypeEditorViewLanguageCode != null && this.currentContentTypeEditorViewLanguageCode.length() > 0) {
                    element.setAttribute("label_" + this.currentContentTypeEditorViewLanguageCode, this.attributeParameterValueLabel);
                } else {
                    element.setAttribute("label", this.attributeParameterValueLabel);
                }
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doInsertAttributeValidator() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String validatorName = this.getRequest().getParameter("validatorName");
            if (validatorName != null && !validatorName.equalsIgnoreCase("")) {
                String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']/xs:annotation/xs:appinfo/form-validation/formset/form";
                Node formNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)validatorsXPath);
                if (formNode != null) {
                    Element newVar;
                    Element element = (Element)formNode;
                    Element newField = document.createElement("field");
                    newField.setAttribute("property", this.attributeName);
                    newField.setAttribute("depends", validatorName);
                    String errorKey = null;
                    if (validatorName.equals("required")) {
                        errorKey = "300";
                    } else if (validatorName.equals("requiredif")) {
                        errorKey = "300";
                        newVar = document.createElement("var");
                        Element varNameElement = this.createTextElement(document, "var-name", "dependent");
                        Element varValueElement = this.createTextElement(document, "var-value", "AttributeName");
                        newVar.appendChild(varNameElement);
                        newVar.appendChild(varValueElement);
                        newField.appendChild(newVar);
                    } else if (validatorName.equals("matchRegexp")) {
                        errorKey = "307";
                        newVar = document.createElement("var");
                        Element varNameElement = this.createTextElement(document, "var-name", "regexp");
                        Element varValueElement = this.createTextElement(document, "var-value", ".*");
                        newVar.appendChild(varNameElement);
                        newVar.appendChild(varValueElement);
                        newField.appendChild(newVar);
                    }
                    Element newMessage = document.createElement("msg");
                    newMessage.setAttribute("name", validatorName);
                    newMessage.setAttribute("key", errorKey);
                    newField.appendChild(newMessage);
                    element.appendChild(newField);
                }
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUpdateAttributeValidatorArguments() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            int i = 0;
            String attributeValidatorName = this.getRequest().getParameter("attributeValidatorName");
            String argumentName = this.getRequest().getParameter(String.valueOf(i) + "_argumentName");
            while (argumentName != null && !argumentName.equalsIgnoreCase("")) {
                String argumentValue = this.getRequest().getParameter(String.valueOf(i) + "_argumentValue");
                String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@property = '" + this.attributeName + "'][@depends = '" + attributeValidatorName + "']";
                Node fieldNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)validatorsXPath);
                if (fieldNode != null) {
                    Element element = (Element)fieldNode;
                    NodeList nl = element.getElementsByTagName("var");
                    int nlIndex = 0;
                    while (nlIndex < nl.getLength()) {
                        Node node = nl.item(nlIndex);
                        element.removeChild(node);
                        ++nlIndex;
                    }
                    Element newVar = document.createElement("var");
                    Element varNameElement = this.createTextElement(document, "var-name", argumentName);
                    Element varValueElement = this.createTextElement(document, "var-value", argumentValue);
                    newVar.appendChild(varNameElement);
                    newVar.appendChild(varValueElement);
                    element.appendChild(newVar);
                }
                argumentName = this.getRequest().getParameter(String.valueOf(++i) + "_argumentName");
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doDeleteAttributeValidator() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            boolean i = false;
            String attributeValidatorName = this.getRequest().getParameter("attributeValidatorName");
            if (attributeValidatorName != null && !attributeValidatorName.equalsIgnoreCase("")) {
                String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@property = '" + this.attributeName + "'][@depends = '" + attributeValidatorName + "']";
                Node fieldNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)validatorsXPath);
                if (fieldNode != null) {
                    Element element = (Element)fieldNode;
                    element.getParentNode().removeChild(element);
                }
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public List getDefinedAssetKeys() {
        return ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public List getDefinedCategoryKeys() throws Exception {
        List categoryKeys = ContentTypeDefinitionController.getController().getDefinedCategoryKeys(this.contentTypeDefinitionVO.getSchemaValue());
        for (CategoryAttribute info : categoryKeys) {
            if (info.getCategoryId() != null) {
                info.setCategoryName(this.getCategoryName(info.getCategoryId()));
                continue;
            }
            info.setCategoryName("Undefined");
        }
        return categoryKeys;
    }

    public String getCategoryName(Integer id) {
        try {
            return categoryController.findById(id).getName();
        }
        catch (SystemException e) {
            return "Category not found";
        }
    }

    public String doInsertAssetKey() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            Element enumeration = ContentTypeDefinitionController.getController().createNewEnumerationKey(document, "assetKeys");
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            logger.warn((Object)"Error adding asset key: ", (Throwable)e);
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doInsertCategoryKey() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            Element enumeration = ContentTypeDefinitionController.getController().createNewEnumerationKey(document, "categoryKeys");
            Element annotation = document.createElement("xs:annotation");
            Element appinfo = document.createElement("xs:appinfo");
            Element params = document.createElement("params");
            enumeration.appendChild(annotation);
            annotation.appendChild(appinfo);
            appinfo.appendChild(params);
            params.appendChild(this.createTextElement(document, "title", this.getRandomName()));
            params.appendChild(this.createTextElement(document, "description", this.getRandomName()));
            params.appendChild(this.createTextElement(document, "categoryId", ""));
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            logger.warn((Object)"Error adding categories key: ", (Throwable)e);
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUpdateAssetKey() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            this.updateAssetEnumerationKey(document, "assetKeys", this.getAssetKey(), this.getNewAssetKey(), this.isMandatory, this.description, this.maximumSize, this.allowedContentTypes, this.imageWidth, this.imageHeight, this.assetUploadTransformationsSettings);
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            logger.warn((Object)"Error updating asset key: ", (Throwable)e);
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doUpdateCategoryKey() throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            Element enumeration = this.updateEnumerationKey(document, "categoryKeys", this.getCategoryKey(), this.getNewCategoryKey());
            if (enumeration != null) {
                Element title = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/title");
                this.setTextElement(title, this.getSingleParameter("title"));
                Element description = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/description");
                this.setTextElement(description, this.getSingleParameter("description"));
                Element categoryId = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/categoryId");
                this.setTextElement(categoryId, this.getSingleParameter("categoryId"));
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            logger.warn((Object)"Error updating category key: ", (Throwable)e);
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public String doDeleteAssetKey() throws Exception {
        return this.deleteKey("assetKeys", this.getAssetKey());
    }

    public String doDeleteCategoryKey() throws Exception {
        return this.deleteKey("categoryKeys", this.getCategoryKey());
    }

    private String deleteKey(String keyType, String key) throws Exception {
        this.initialize(this.getContentTypeDefinitionId());
        try {
            Document document = this.createDocumentFromDefinition();
            String attributesXPath = "/xs:schema/xs:simpleType[@name = '" + keyType + "']/xs:restriction/xs:enumeration[@value='" + key + "']";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            if (anl != null && anl.getLength() > 0) {
                Element element = (Element)anl.item(0);
                element.getParentNode().removeChild(element);
            }
            this.saveUpdatedDefinition(document);
        }
        catch (Exception e) {
            logger.warn((Object)("Error updating key: " + keyType), (Throwable)e);
        }
        this.initialize(this.getContentTypeDefinitionId());
        return USE_EDITOR;
    }

    public CategoryController getCategoryController() {
        return categoryController;
    }

    public List getAllCategories() throws SystemException {
        return this.getCategoryController().findAllActiveCategories();
    }

    private Document createDocumentFromDefinition() throws SAXException, IOException {
        String contentTypeDefinitionString = this.contentTypeDefinitionVO.getSchemaValue();
        InputSource xmlSource = new InputSource(new StringReader(contentTypeDefinitionString));
        DOMParser parser = new DOMParser();
        parser.parse(xmlSource);
        return parser.getDocument();
    }

    private void saveUpdatedDefinition(Document document) throws ConstraintException, SystemException {
        StringBuffer sb = new StringBuffer();
        XMLHelper.serializeDom(document.getDocumentElement(), sb);
        this.contentTypeDefinitionVO.setSchemaValue(sb.toString());
        ContentTypeDefinitionController.getController().update(this.contentTypeDefinitionVO);
    }

    private Element updateEnumerationKey(Document document, String keyType, String oldKey, String newKey) throws TransformerException {
        String attributesXPath = "/xs:schema/xs:simpleType[@name = '" + keyType + "']/xs:restriction/xs:enumeration[@value='" + oldKey + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
        if (anl != null && anl.getLength() > 0) {
            Element enumeration = (Element)anl.item(0);
            enumeration.setAttribute("value", newKey);
            return enumeration;
        }
        return null;
    }

    private Element updateAssetEnumerationKey(Document document, String keyType, String oldKey, String newKey, Boolean isMandatory, String description, Integer maximumSize, String allowedContentTypes, String imageWidth, String imageHeight, String assetUploadTransformationsSettings) throws TransformerException {
        if (isMandatory == null) {
            isMandatory = new Boolean(false);
        }
        if (description == null) {
            description = "Undefined";
        }
        if (maximumSize == null) {
            maximumSize = new Integer(100);
        }
        if (allowedContentTypes == null) {
            allowedContentTypes = "*";
        }
        if (imageWidth == null) {
            imageWidth = "*";
        }
        if (imageHeight == null) {
            imageHeight = "*";
        }
        String attributesXPath = "/xs:schema/xs:simpleType[@name = '" + keyType + "']/xs:restriction/xs:enumeration[@value='" + oldKey + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
        if (anl != null && anl.getLength() > 0) {
            Element enumeration = (Element)anl.item(0);
            enumeration.setAttribute("value", newKey);
            Element isMandatoryElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/isMandatory");
            Element descriptionElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/description");
            Element maximumSizeElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/maximumSize");
            Element allowedContentTypesElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/allowedContentTypes");
            Element imageWidthElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/imageWidth");
            Element imageHeightElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/imageHeight");
            Element assetUploadTransformationsSettingsElement = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)"xs:annotation/xs:appinfo/params/assetUploadTransformationsSettings");
            if (isMandatoryElement == null && descriptionElement != null) {
                isMandatoryElement = this.createTextElement(document, "isMandatory", isMandatory.toString());
                descriptionElement.getParentNode().appendChild(isMandatoryElement);
            }
            if (assetUploadTransformationsSettingsElement == null && descriptionElement != null) {
                assetUploadTransformationsSettingsElement = this.createTextElement(document, "assetUploadTransformationsSettings", assetUploadTransformationsSettings.toString());
                descriptionElement.getParentNode().appendChild(assetUploadTransformationsSettingsElement);
            }
            if (descriptionElement == null) {
                Element annotation = document.createElement("xs:annotation");
                Element appinfo = document.createElement("xs:appinfo");
                Element params = document.createElement("params");
                enumeration.appendChild(annotation);
                annotation.appendChild(appinfo);
                appinfo.appendChild(params);
                descriptionElement = this.createTextElement(document, "description", this.getRandomName());
                maximumSizeElement = this.createTextElement(document, "maximumSize", maximumSize.toString());
                allowedContentTypesElement = this.createTextElement(document, "allowedContentTypes", allowedContentTypes);
                imageWidthElement = this.createTextElement(document, "imageWidth", imageWidth);
                imageHeightElement = this.createTextElement(document, "imageHeight", imageHeight);
                isMandatoryElement = this.createTextElement(document, "isMandatory", isMandatory.toString());
                assetUploadTransformationsSettingsElement = this.createTextElement(document, "assetUploadTransformationsSettings", assetUploadTransformationsSettings.toString());
                params.appendChild(descriptionElement);
                params.appendChild(maximumSizeElement);
                params.appendChild(allowedContentTypesElement);
                params.appendChild(imageWidthElement);
                params.appendChild(imageHeightElement);
                params.appendChild(isMandatoryElement);
            } else {
                this.setTextElement(isMandatoryElement, isMandatory.toString());
                this.setTextElement(descriptionElement, description);
                this.setTextElement(maximumSizeElement, maximumSize.toString());
                this.setTextElement(allowedContentTypesElement, allowedContentTypes);
                this.setTextElement(imageWidthElement, imageWidth);
                this.setTextElement(imageHeightElement, imageHeight);
                this.setTextElement(assetUploadTransformationsSettingsElement, assetUploadTransformationsSettings);
            }
            return enumeration;
        }
        return null;
    }

    private Element createTextElement(Document document, String tagName, String value) {
        Element e = document.createElement(tagName);
        e.appendChild(document.createTextNode(value));
        return e;
    }

    private void setTextElement(Element e, String value) {
        if (e.getFirstChild() != null) {
            e.getFirstChild().setNodeValue(value);
        } else {
            e.appendChild(e.getOwnerDocument().createTextNode(value));
        }
    }

    private String getRandomName() {
        return "undefined" + (int)(Math.random() * 100.0);
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionVO.getContentTypeDefinitionId();
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) throws Exception {
        this.contentTypeDefinitionVO.setContentTypeDefinitionId(contentTypeDefinitionId);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.contentTypeDefinitionVO.getName();
    }

    public String getSchemaValue() {
        return this.contentTypeDefinitionVO.getSchemaValue();
    }

    public Integer getType() {
        return this.contentTypeDefinitionVO.getType();
    }

    public List getContentTypeAttributes() {
        return this.attributes;
    }

    public String getInputTypeId() {
        return this.inputTypeId;
    }

    public void setInputTypeId(String string) {
        this.inputTypeId = string;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setNewAttributeName(String newAttributeName) {
        this.newAttributeName = newAttributeName;
    }

    public String getAttributeParameterValueId() {
        return this.attributeParameterValueId;
    }

    public void setAttributeParameterValueId(String string) {
        this.attributeParameterValueId = string;
    }

    public String getAttributeParameterId() {
        return this.attributeParameterId;
    }

    public void setAttributeParameterId(String string) {
        this.attributeParameterId = string;
    }

    public String getAttributeParameterValueLabel() {
        return this.attributeParameterValueLabel;
    }

    public String getNewAttributeParameterValueId() {
        return this.newAttributeParameterValueId;
    }

    public void setAttributeParameterValueLabel(String string) {
        this.attributeParameterValueLabel = string;
    }

    public void setNewAttributeParameterValueId(String string) {
        this.newAttributeParameterValueId = string;
    }

    public String getAttributeParameterValueLocale() {
        return this.attributeParameterValueLocale;
    }

    public void setAttributeParameterValueLocale(String string) {
        this.attributeParameterValueLocale = string;
    }

    public String getAttributeToExpand() {
        return this.attributeToExpand;
    }

    public void setAttributeToExpand(String string) {
        this.attributeToExpand = string;
    }

    public String getCurrentContentTypeEditorViewLanguageCode() {
        return this.currentContentTypeEditorViewLanguageCode;
    }

    public void setCurrentContentTypeEditorViewLanguageCode(String string) {
        this.currentContentTypeEditorViewLanguageCode = string;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public void setAssetKey(String s) {
        this.assetKey = s;
    }

    public String getNewAssetKey() {
        return this.newAssetKey;
    }

    public void setNewAssetKey(String s) {
        this.newAssetKey = s;
    }

    public String getCategoryKey() {
        return this.categoryKey;
    }

    public void setCategoryKey(String s) {
        this.categoryKey = s;
    }

    public String getNewCategoryKey() {
        return this.newCategoryKey;
    }

    public void setNewCategoryKey(String s) {
        this.newCategoryKey = s;
    }

    public String getErrorKey() {
        return "ContentTypeAttribute.updateAction";
    }

    public String getReturnAddress() {
        return "ViewListContentTypeDefinition.action";
    }

    public String getAllowedContentTypes() {
        return this.allowedContentTypes;
    }

    public void setAllowedContentTypes(String assetContentType) {
        this.allowedContentTypes = assetContentType;
    }

    public String getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(String imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(String imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getActivatedName() {
        return this.activatedName;
    }

    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    public void setIsMandatory(Boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public String getAssetUploadTransformationsSettings() {
        return this.assetUploadTransformationsSettings;
    }

    public void setAssetUploadTransformationsSettings(String assetUploadTransformationsSettings) {
        this.assetUploadTransformationsSettings = assetUploadTransformationsSettings;
    }
}

