/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.FileUploadHelper;
import webwork.action.ActionContext;

public class ViewArchiveToolAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private int numberOfVersionsToKeep = 3;
    private int assetFileSizeLimit = 5000000;
    private int assetNumberLimit = 50;
    private List optimizationBeanList = new ArrayList();
    private String[] digitalAssetId;
    private String archiveUrl;
    private StringBuffer archiveFileSize = new StringBuffer();
    private boolean nullAssets = false;

    public String doInput() throws Exception {
        return "input";
    }

    public String doInputArchiveOldAssets() throws Exception {
        this.optimizationBeanList = ContentVersionController.getContentVersionController().getHeavyContentVersions(this.numberOfVersionsToKeep, this.assetFileSizeLimit, this.assetNumberLimit);
        return "inputArchiveOldAssets";
    }

    public String doInputRestoreAssetArchive() throws Exception {
        return "inputRestoreAssetArchive";
    }

    public String doArchiveOldAssets() throws Exception {
        this.archiveUrl = DigitalAssetController.getController().archiveDigitalAssets(this.digitalAssetId, this.archiveFileSize, this.nullAssets);
        return "successArchive";
    }

    public String doRestoreAssetArchive() throws Exception {
        ActionContext.getContext();
        File file = FileUploadHelper.getUploadedFile(ActionContext.getMultiPartRequest());
        if (file == null || !file.exists()) {
            throw new SystemException("The file upload must have gone bad as no file reached the restore utility.");
        }
        DigitalAssetController.getController().restoreAssetArchive(file);
        return "successRestoreArchive";
    }

    public String doExecute() throws Exception {
        return "success";
    }

    public int getNumberOfVersionsToKeep() {
        return this.numberOfVersionsToKeep;
    }

    public void setNumberOfVersionsToKeep(int numberOfVersionsToKeep) {
        this.numberOfVersionsToKeep = numberOfVersionsToKeep;
    }

    public List getOptimizationBeanList() {
        return this.optimizationBeanList;
    }

    public void setDigitalAssetId(String[] digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }

    public String getArchiveUrl() {
        return this.archiveUrl;
    }

    public String getArchiveFileSize() {
        return this.archiveFileSize.toString();
    }

    public int getAssetFileSizeLimit() {
        return this.assetFileSizeLimit;
    }

    public int getAssetNumberLimit() {
        return this.assetNumberLimit;
    }

    public void setAssetFileSizeLimit(int assetFileSizeLimit) {
        this.assetFileSizeLimit = assetFileSizeLimit;
    }

    public void setAssetNumberLimit(int assetNumberLimit) {
        this.assetNumberLimit = assetNumberLimit;
    }

    public boolean getNullAssets() {
        return this.nullAssets;
    }

    public void setNullAssets(boolean nullAssets) {
        this.nullAssets = nullAssets;
    }
}

