/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.PortletAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.portal.deploy.Deploy;
import org.infoglue.deliver.portal.om.PortletApplicationEntityImpl;
import org.infoglue.deliver.portal.om.PortletApplicationEntityListImpl;
import org.infoglue.deliver.portal.om.PortletEntityImpl;
import org.infoglue.deliver.portal.om.PreferenceImpl;
import org.infoglue.deliver.portal.om.PreferenceSetImpl;
import webwork.action.ActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class UploadPortletAction
extends InfoGlueAbstractAction {
    private static final Log log = LogFactory.getLog(UploadPortletAction.class);
    private static final String PORTLET_DEPLOY_PREFIX = "portlet.deploy";
    private DigitalAsset digitalAsset;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doExecute() {
        block14: {
            File uploadedFile;
            String name;
            MultiPartRequestWrapper mpr;
            block13: {
                block12: {
                    mpr = ActionContext.getMultiPartRequest();
                    if (mpr != null) break block12;
                    return "input";
                }
                log.debug((Object)"Handling upload...");
                Enumeration names = mpr.getFileNames();
                if (!names.hasMoreElements()) throw new SystemException("No file was uploaded...");
                name = (String)names.nextElement();
                log.debug((Object)("name:" + name));
                uploadedFile = mpr.getFile(name);
                if (uploadedFile != null && uploadedFile.length() != 0L) break block13;
                log.error((Object)"No file found in multipart request");
                return "input";
            }
            try {
                String contentType = mpr.getContentType(name);
                String fileName = mpr.getFilesystemName(name);
                String filePath = CmsPropertyHandler.getDigitalAssetPath();
                log.debug((Object)("fileName:" + fileName));
                String appName = fileName;
                int dot = appName.lastIndexOf(".");
                if (dot > 0) {
                    appName = appName.substring(0, dot);
                }
                log.info((Object)("appName:" + appName));
                File file = new File(uploadedFile.getParentFile(), "tmp" + System.currentTimeMillis());
                log.info((Object)("file:" + file.getAbsolutePath()));
                PortletApplicationDefinition pad = Deploy.prepareArchive(uploadedFile, file, appName);
                log.info((Object)("Adding portlet application to registry: " + appName));
                PortletApplicationEntityImpl pae = new PortletApplicationEntityImpl();
                pae.setId(appName);
                PortletDefinitionList pdl = pad.getPortletDefinitionList();
                for (PortletDefinition pd : pdl) {
                    log.debug((Object)("Adding portlet: " + pd.getName()));
                    PortletEntityImpl pe = new PortletEntityImpl();
                    pe.setId(pd.getName());
                    ArrayList<PreferenceImpl> destPrefs = new ArrayList<PreferenceImpl>();
                    PreferenceSet prefSet = pd.getPreferenceSet();
                    for (Preference src : prefSet) {
                        ArrayList destValues = new ArrayList();
                        Iterator values = src.getValues();
                        while (values.hasNext()) {
                            destValues.add(values.next());
                        }
                        destPrefs.add(new PreferenceImpl(src.getName(), destValues));
                    }
                    pe.setPreferenceSet(new PreferenceSetImpl(destPrefs));
                    pae.addPortletEntity(pe);
                }
                log.debug((Object)"Creating Digital Asset...");
                DigitalAssetVO newAsset = new DigitalAssetVO();
                newAsset.setAssetContentType(contentType);
                newAsset.setAssetKey(fileName);
                newAsset.setAssetFileName(fileName);
                newAsset.setAssetFilePath(filePath);
                newAsset.setAssetFileSize(new Integer(new Long(file.length()).intValue()));
                List assets = PortletAssetController.getDigitalAssetByName(fileName);
                if (assets != null && assets.size() > 0) {
                    log.info((Object)("Removing old instance of " + fileName));
                    for (DigitalAsset oldAsset : assets) {
                        PortletAssetController.delete(oldAsset.getId());
                    }
                }
                log.info((Object)("Storing Digital Asset (portlet) " + fileName));
                FileInputStream is = new FileInputStream(file);
                this.digitalAsset = PortletAssetController.create(newAsset, is);
                ((InputStream)is).close();
                log.debug((Object)("Digital Asset stored as id=" + this.digitalAsset.getId()));
                uploadedFile.delete();
                file.delete();
                PortletApplicationEntityList pael = PortletEntityRegistry.getPortletApplicationEntityList();
                if (pael instanceof PortletApplicationEntityListImpl) {
                    ((PortletApplicationEntityListImpl)pael).add(pae);
                    log.debug((Object)"Portlet application successfully added to registry");
                    break block14;
                }
                log.error((Object)"Unknown implementation of PortletApplicationEntityList, cannot add portlet application!");
                return "error";
            }
            catch (Throwable e) {
                log.error((Object)"ERROR", e);
                return "error";
            }
        }
        PortletEntityRegistry.store();
        this.updateDeliverEngines(this.digitalAsset.getId());
        return "success";
    }

    private void updateDeliverEngines(Integer digitalAssetId) {
        List allUrls = CmsPropertyHandler.getInternalDeliveryUrls();
        allUrls.addAll(CmsPropertyHandler.getPublicDeliveryUrls());
        Iterator urlIterator = allUrls.iterator();
        while (urlIterator.hasNext()) {
            String url = String.valueOf((String)urlIterator.next()) + "/DeployPortlet.action";
            try {
                HttpClient client = new HttpClient();
                client.setConnectionTimeout(5000);
                GetMethod method = new GetMethod(url);
                method.setQueryString("digitalAssetId=" + digitalAssetId);
                method.setFollowRedirects(true);
                client.executeMethod((HttpMethod)method);
                StatusLine status = method.getStatusLine();
                if (status != null && status.getStatusCode() == 200) {
                    log.info((Object)("Successfully deployed portlet at " + url));
                } else {
                    log.warn((Object)("Failed to deploy portlet at " + url + ": " + status));
                }
                method.releaseConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public DigitalAsset getDigitalAsset() {
        return this.digitalAsset;
    }
}

