/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import webwork.action.ActionContext;

public class UpdateSystemUserPasswordAction
extends InfoGlueAbstractAction {
    private String userName;
    private String oldPassword;
    private String newPassword;
    private String verifiedNewPassword;
    private String returnAddress;

    public String doInput() throws Exception {
        return "input";
    }

    public String doInputV3() throws Exception {
        return "inputV3";
    }

    public String doInputStandalone() throws Exception {
        return "inputStandalone";
    }

    protected String doExecute() throws Exception {
        if (this.userName.equals(CmsPropertyHandler.getAnonymousUser())) {
            throw new SystemException("You must not change password on this user as it's needed by the system.");
        }
        if (!this.newPassword.equals(this.verifiedNewPassword)) {
            throw new ConstraintException("SystemUser.newPassword", "309");
        }
        UserControllerProxy.getController().updateUserPassword(this.userName, this.oldPassword, this.newPassword);
        if (this.returnAddress != null && !this.returnAddress.equalsIgnoreCase("")) {
            ActionContext.getResponse().sendRedirect(this.returnAddress);
            return "none";
        }
        return "success";
    }

    public String doV3() throws Exception {
        try {
            if (this.userName.equals(CmsPropertyHandler.getAnonymousUser())) {
                throw new SystemException("You must not change password on this user as it's needed by the system.");
            }
            if (!this.newPassword.equals(this.verifiedNewPassword)) {
                throw new ConstraintException("SystemUser.newPassword", "309");
            }
            UserControllerProxy.getController().updateUserPassword(this.userName, this.oldPassword, this.newPassword);
        }
        catch (ConstraintException e) {
            e.setResult("inputV3");
            throw e;
        }
        if (this.returnAddress != null && !this.returnAddress.equalsIgnoreCase("")) {
            ActionContext.getResponse().sendRedirect(this.returnAddress);
            return "none";
        }
        return "successV3";
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getVerifiedNewPassword() {
        return this.verifiedNewPassword;
    }

    public void setVerifiedNewPassword(String verifiedNewPassword) {
        this.verifiedNewPassword = verifiedNewPassword;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }
}

