/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.List;
import org.infoglue.cms.applications.managementtool.actions.ViewSystemUserAction;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateSystemUserAction
extends ViewSystemUserAction {
    private ConstraintExceptionBuffer ceb;
    private SystemUserVO systemUserVO;
    private RoleVO roleVO;
    private InfoGluePrincipal infoGluePrincipal;
    private String[] roller;
    private List defRoles;
    private String action;
    private String oldPassword;

    public UpdateSystemUserAction() {
        this(new SystemUserVO());
    }

    public UpdateSystemUserAction(SystemUserVO systemUserVO) {
        this.systemUserVO = systemUserVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getInfoGluePrincipal().getName());
        this.ceb = this.systemUserVO.validate();
        this.ceb.throwIfNotEmpty();
        String[] roles = this.getRequest().getParameterValues("roleName");
        String[] groups = this.getRequest().getParameterValues("groupName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        UserControllerProxy.getController().updateUser(this.systemUserVO, roles, groups);
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            UserPropertiesController.getController().updateContentTypeDefinitions(this.getUserName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doChangePassword() throws Exception {
        if (this.systemUserVO.getUserName().equals(CmsPropertyHandler.getAnonymousUser())) {
            UserControllerProxy.getController().updateAnonymousUserPassword();
        } else {
            UserControllerProxy.getController().updateUserPassword(this.systemUserVO.getUserName());
        }
        return "passwordSentSuccess";
    }

    public String doV3() throws Exception {
        this.doExecute();
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        this.doV3();
        return "saveAndExitV3";
    }

    public String doChangePasswordV3() throws Exception {
        this.doChangePassword();
        return "passwordSentSuccessV3";
    }

    private String[] getRoller() {
        return this.roller;
    }

    public String getFirstName() {
        return this.systemUserVO.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.systemUserVO.setFirstName(firstName);
    }

    public String getLastName() {
        return this.systemUserVO.getLastName();
    }

    public void setLastName(String lastName) {
        this.systemUserVO.setLastName(lastName);
    }

    public String getUserName() {
        return this.systemUserVO.getUserName();
    }

    public void setUserName(String userName) {
        this.systemUserVO.setUserName(userName);
    }

    public String getEmail() {
        return this.systemUserVO.getEmail();
    }

    public void setEmail(String email) throws Exception {
        this.systemUserVO.setEmail(email);
    }

    public String getPassword() {
        return this.systemUserVO.getPassword();
    }

    public void setPassword(String password) {
        this.systemUserVO.setPassword(password);
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }
}

