/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewSiteNodeTypeDefinitionAction;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinitionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateSiteNodeTypeDefinitionAction
extends ViewSiteNodeTypeDefinitionAction {
    private SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO;
    private Integer siteNodeTypeDefinitionId;
    private String name;
    private String description;
    private String invokerClassName;
    private ConstraintExceptionBuffer ceb;

    public UpdateSiteNodeTypeDefinitionAction() {
        this(new SiteNodeTypeDefinitionVO());
    }

    public UpdateSiteNodeTypeDefinitionAction(SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO) {
        this.siteNodeTypeDefinitionVO = siteNodeTypeDefinitionVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getSiteNodeTypeDefinitionId());
        this.ceb.add(this.siteNodeTypeDefinitionVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] values = this.getRequest().getParameterValues("availableServiceBindingId");
        SiteNodeTypeDefinitionController.getController().update(this.siteNodeTypeDefinitionVO, values);
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionVO.setSiteNodeTypeDefinitionId(siteNodeTypeDefinitionId);
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionVO.getSiteNodeTypeDefinitionId();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.siteNodeTypeDefinitionVO.getName();
    }

    public void setName(String name) {
        try {
            this.siteNodeTypeDefinitionVO.setName(name);
        }
        catch (ConstraintException ce) {
            this.name = name;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.siteNodeTypeDefinitionVO.getDescription();
    }

    public void setDescription(String description) {
        try {
            this.siteNodeTypeDefinitionVO.setDescription(description);
        }
        catch (ConstraintException ce) {
            this.description = description;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getInvokerClassName() {
        if (this.invokerClassName != null) {
            return this.invokerClassName;
        }
        return this.siteNodeTypeDefinitionVO.getInvokerClassName();
    }

    public void setInvokerClassName(String invokerClassName) {
        try {
            this.siteNodeTypeDefinitionVO.setInvokerClassName(invokerClassName);
        }
        catch (ConstraintException ce) {
            this.invokerClassName = invokerClassName;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }
}

