/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewRoleAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateRoleAction
extends ViewRoleAction {
    private ConstraintExceptionBuffer ceb;
    private RoleVO roleVO;

    public UpdateRoleAction() {
        this(new RoleVO());
    }

    public UpdateRoleAction(RoleVO RoleVO2) {
        this.roleVO = RoleVO2;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getRoleName());
        this.ceb.add(this.roleVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] values = this.getRequest().getParameterValues("userName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        RoleControllerProxy.getController().updateRole(this.roleVO, values);
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            RolePropertiesController.getController().updateContentTypeDefinitions(this.getRoleName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doV3() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException e) {
            e.setResult("inputV3");
            throw e;
        }
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException e) {
            e.setResult("inputV3");
            throw e;
        }
        return "saveAndExitV3";
    }

    public void setRoleName(String roleName) {
        this.roleVO.setRoleName(roleName);
    }

    public String getRoleName() {
        return this.roleVO.getRoleName();
    }

    public void setDescription(String description) {
        this.roleVO.setDescription(description);
    }

    public String getDescription() {
        return this.roleVO.getDescription();
    }
}

