/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewRepositoryAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateRepositoryAction
extends ViewRepositoryAction {
    private RepositoryVO repositoryVO;
    private Integer repositoryId;
    private String userAction = "";
    private ConstraintExceptionBuffer ceb;

    public UpdateRepositoryAction() {
        this(new RepositoryVO());
    }

    public UpdateRepositoryAction(RepositoryVO repositoryVO) {
        this.repositoryVO = repositoryVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getRepositoryId());
        this.ceb.add(this.repositoryVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] values = this.getRequest().getParameterValues("languageId");
        RepositoryController.getController().update(this.repositoryVO, values);
        return "success";
    }

    public String doLocal() throws Exception {
        super.initialize(this.getRepositoryId());
        this.ceb.throwIfNotEmpty();
        RepositoryController.getController().update(this.repositoryVO);
        return "successLocal";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doSaveAndExitLocal() throws Exception {
        this.doLocal();
        return "saveAndExitLocal";
    }

    public void setRepositoryId(Integer repositoryId) throws Exception {
        this.repositoryVO.setRepositoryId(repositoryId);
    }

    public Integer getRepositoryId() {
        return this.repositoryVO.getRepositoryId();
    }

    public String getName() {
        return this.repositoryVO.getName();
    }

    public void setName(String name) {
        this.repositoryVO.setName(name);
    }

    public String getDescription() {
        return this.repositoryVO.getDescription();
    }

    public void setDescription(String description) {
        this.repositoryVO.setDescription(description);
    }

    public String getDnsName() {
        return this.repositoryVO.getDnsName();
    }

    public void setDnsName(String dnsName) {
        this.repositoryVO.setDnsName(dnsName);
    }
}

