/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewRedirectAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RedirectController;
import org.infoglue.cms.entities.management.RedirectVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateRedirectAction
extends ViewRedirectAction {
    private RedirectVO redirectVO;
    private Integer redirectId;
    private String userAction = "";
    private ConstraintExceptionBuffer ceb;

    public UpdateRedirectAction() {
        this(new RedirectVO());
    }

    public UpdateRedirectAction(RedirectVO redirectVO) {
        this.redirectVO = redirectVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getRedirectId());
        this.ceb.add(this.redirectVO.validate());
        this.ceb.throwIfNotEmpty();
        RedirectController.getController().update(this.redirectVO);
        return "success";
    }

    public String doLocal() throws Exception {
        super.initialize(this.getRedirectId());
        this.ceb.throwIfNotEmpty();
        RedirectController.getController().update(this.redirectVO);
        return "successLocal";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doSaveAndExitLocal() throws Exception {
        this.doLocal();
        return "saveAndExitLocal";
    }

    public void setRedirectId(Integer redirectId) throws Exception {
        this.redirectVO.setRedirectId(redirectId);
    }

    public Integer getRedirectId() {
        return this.redirectVO.getRedirectId();
    }

    public String getUrl() {
        return this.redirectVO.getUrl();
    }

    public void setUrl(String url) {
        this.redirectVO.setUrl(url);
    }

    public String getRedirectUrl() {
        return this.redirectVO.getRedirectUrl();
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectVO.setRedirectUrl(redirectUrl);
    }
}

