/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.PortletAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.cms.util.RemoteCacheUpdater;

public class UpdatePortletRegistryAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)UpdatePortletRegistryAction.class.getName());
    private String portletRegistry;

    public String doExecute() throws Exception {
        this.store();
        return "success";
    }

    private void store() throws IOException {
        logger.info((Object)("Storing PortletEntityRegistry...\n" + this.portletRegistry));
        try {
            Database db = CastorDatabaseService.getDatabase();
            db.begin();
            byte[] serial = this.portletRegistry.getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(serial);
            DigitalAsset da = PortletAssetController.getPortletAssetController().getPortletRegistryAsset(db);
            if (da == null) {
                logger.info((Object)"Creating new portletentityregistry.xml");
                String filePath = CmsPropertyHandler.getDigitalAssetPath();
                DigitalAssetVO newAsset = new DigitalAssetVO();
                newAsset.setAssetContentType("text/xml");
                newAsset.setAssetKey("portletentityregistry.xml");
                newAsset.setAssetFileName("portletentityregistry.xml");
                newAsset.setAssetFilePath(filePath);
                newAsset.setAssetFileSize(new Integer(serial.length));
                da = PortletAssetController.getPortletAssetController().create(db, newAsset, is);
                logger.warn((Object)("portletentityregistry.xml stored as id=" + da.getId()));
            } else {
                logger.info((Object)"Updating portletentityregistry.xml");
                DigitalAssetVO daVO = da.getValueObject();
                daVO.setAssetFileSize(new Integer(serial.length));
                PortletAssetController.update(daVO, is);
            }
            ((InputStream)is).close();
            PortletEntityRegistry.load();
            NotificationMessage notificationMessage = new NotificationMessage("UpdatePortletRegistryAction.store():", "PortletRegistry", this.getInfoGluePrincipal().getName(), 100, "0", "PortletRegistry");
            RemoteCacheUpdater.getSystemNotificationMessages().add(notificationMessage);
            db.commit();
            db.close();
            logger.debug((Object)"Stored PortletEntityRegistry successfully");
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to store PortletEntityRegistry", e);
        }
    }

    public String getPortletRegistry() {
        return this.portletRegistry;
    }

    public void setPortletRegistry(String portletRegistry) {
        this.portletRegistry = portletRegistry;
    }
}

