/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewLanguageAction;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateLanguageAction
extends ViewLanguageAction {
    private LanguageVO languageVO;
    private Integer languageId;
    private String name;
    private String languageCode;
    private ConstraintExceptionBuffer ceb;

    public UpdateLanguageAction() {
        this(new LanguageVO());
    }

    public UpdateLanguageAction(LanguageVO languageVO) {
        this.languageVO = languageVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getLanguageId());
        this.ceb.add(this.languageVO.validate());
        this.ceb.throwIfNotEmpty();
        LanguageController.getController().update(this.languageVO);
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public void setLanguageId(Integer languageId) {
        this.languageVO.setLanguageId(languageId);
    }

    public Integer getLanguageId() {
        return this.languageVO.getLanguageId();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.languageVO.getName();
    }

    public void setName(String name) {
        try {
            this.languageVO.setName(name);
        }
        catch (ConstraintException ce) {
            this.name = name;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getLanguageCode() {
        if (this.languageCode != null) {
            return this.languageCode;
        }
        return this.languageVO.getLanguageCode();
    }

    public void setLanguageCode(String languageCode) {
        try {
            this.languageVO.setLanguageCode(languageCode);
        }
        catch (ConstraintException ce) {
            this.languageCode = languageCode;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getCharset() {
        return this.languageVO.getCharset();
    }

    public void setCharset(String charset) {
        this.languageVO.setCharset(charset);
    }
}

