/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.managementtool.actions.ViewGroupAction;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateGroupAction
extends ViewGroupAction {
    private ConstraintExceptionBuffer ceb;
    private GroupVO groupVO;

    public UpdateGroupAction() {
        this(new GroupVO());
    }

    public UpdateGroupAction(GroupVO GroupVO2) {
        this.groupVO = GroupVO2;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.getGroupName());
        this.ceb.add(this.groupVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] values = this.getRequest().getParameterValues("userName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        GroupControllerProxy.getController().updateGroup(this.groupVO, values);
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            GroupPropertiesController.getController().updateContentTypeDefinitions(this.getGroupName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doV3() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException e) {
            e.setResult("inputV3");
            throw e;
        }
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException e) {
            e.setResult("inputV3");
            throw e;
        }
        return "saveAndExitV3";
    }

    public void setGroupName(String groupName) {
        this.groupVO.setGroupName(groupName);
    }

    public String getGroupName() {
        return this.groupVO.getGroupName();
    }

    public void setDescription(String description) {
        this.groupVO.setDescription(description);
    }

    public String getDescription() {
        return this.groupVO.getDescription();
    }
}

