/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;

public class RebuildRegistryAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)RebuildRegistryAction.class.getName());
    private Integer repositoryId = null;
    private String fileUrl = "";
    private String fileName = "";

    public String doInput() throws Exception {
        return "input";
    }

    protected String doExecute() throws Exception {
        RegistryController registryController = RegistryController.getController();
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                db.begin();
                List siteNodes = SiteNodeController.getController().getRepositorySiteNodes(this.repositoryId, db);
                for (SiteNode siteNode : siteNodes) {
                    logger.info((Object)("Going to index all versions of " + siteNode.getName()));
                    for (SiteNodeVersion siteNodeVersion : siteNode.getSiteNodeVersions()) {
                        registryController.updateSiteNodeVersion(siteNodeVersion, db);
                    }
                }
                List languages = LanguageController.getController().getLanguageList(this.repositoryId, db);
                List contents = ContentController.getContentController().getRepositoryContents(this.repositoryId, db);
                for (Content content : contents) {
                    logger.info((Object)("Going to index all version of " + content.getName()));
                    for (ContentVersion contentVersion : content.getContentVersions()) {
                        registryController.updateContentVersion(contentVersion, db);
                    }
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error was found rebuilding the registry: " + e.getMessage()), (Throwable)e);
                db.rollback();
                db.close();
            }
        }
        finally {
            db.close();
        }
        return "success";
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }
}

