/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.Mapping;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ImportController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.FileUploadHelper;
import webwork.action.ActionContext;

public class ImportRepositoryAction
extends InfoGlueAbstractAction {
    public static final Logger logger = Logger.getLogger((String)ImportRepositoryAction.class.getName());
    private String onlyLatestVersions = "true";

    public String doInput() throws Exception {
        return "input";
    }

    protected String doExecute() throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            ActionContext.getContext();
            File file = FileUploadHelper.getUploadedFile(ActionContext.getMultiPartRequest());
            if (file == null || !file.exists()) {
                throw new SystemException("The file upload must have gone bad as no file reached the import utility.");
            }
            String encoding = "UTF-8";
            int version = 1;
            FileInputStream fisTemp = new FileInputStream(file);
            InputStreamReader readerTemp = new InputStreamReader((InputStream)fisTemp, encoding);
            BufferedReader bufferedReaderTemp = new BufferedReader(readerTemp);
            String line = bufferedReaderTemp.readLine();
            int index = 0;
            while (line != null && index < 50) {
                logger.info((Object)("line:" + line + '\n'));
                if (line.indexOf("contentTypeDefinitionId") > -1) {
                    logger.info((Object)"This was a new export...");
                    version = 2;
                    break;
                }
                line = bufferedReaderTemp.readLine();
                ++index;
            }
            bufferedReaderTemp.close();
            readerTemp.close();
            fisTemp.close();
            Mapping map = new Mapping();
            if (version == 1) {
                logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_site.xml").toString()));
                map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_site.xml").toString());
            } else if (version == 2) {
                logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_site_2.5.xml").toString()));
                map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_site_2.5.xml").toString());
            }
            db.begin();
            HashMap contentIdMap = new HashMap();
            HashMap siteNodeIdMap = new HashMap();
            ArrayList allContentIds = new ArrayList();
            ImportController.getController().importRepository(db, map, file, encoding, version, this.onlyLatestVersions, contentIdMap, siteNodeIdMap, allContentIds);
            db.commit();
            db.close();
            for (Integer contentId : allContentIds) {
                try {
                    try {
                        db = CastorDatabaseService.getDatabase();
                        db.begin();
                        Content content = ContentController.getContentController().getContentWithId(contentId, db);
                        ImportController.getController().updateContentVersions(content, contentIdMap, siteNodeIdMap, this.onlyLatestVersions);
                        db.commit();
                    }
                    catch (Exception e) {
                        try {
                            db.rollback();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        logger.error((Object)("An error occurred when updating content version for content: " + e.getMessage()), (Throwable)e);
                        db.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
                db.close();
            }
            catch (Exception e1) {
                logger.error((Object)("An error occurred when importing a repository: " + e.getMessage()), (Throwable)e);
                throw new SystemException("An error occurred when importing a repository: " + e.getMessage(), e);
            }
            logger.error((Object)("An error occurred when importing a repository: " + e.getMessage()), (Throwable)e);
            throw new SystemException("An error occurred when importing a repository: " + e.getMessage(), e);
        }
        return "success";
    }

    public String getOnlyLatestVersions() {
        return this.onlyLatestVersions;
    }

    public void setOnlyLatestVersions(String onlyLatestVersions) {
        this.onlyLatestVersions = onlyLatestVersions;
    }
}

