/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.impl.simple.InfoGlueExportImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.handlers.DigitalAssetBytesHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportRepositoryAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ExportRepositoryAction.class.getName());
    private Integer repositoryId = null;
    private List repositories = new ArrayList();
    private String fileUrl = "";
    private String fileName = "";
    private String exportFileName = null;
    private int assetMaxSize = -1;

    public String doInput() throws Exception {
        this.repositories = RepositoryController.getController().getRepositoryVOList();
        return "input";
    }

    @Override
    protected String doExecute() throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            Mapping map = new Mapping();
            String exportFormat = CmsPropertyHandler.getExportFormat();
            if (exportFormat.equalsIgnoreCase("2")) {
                logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_site_2.5.xml").toString()));
                map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_site_2.5.xml").toString());
            } else {
                logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_site.xml").toString()));
                map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_site.xml").toString());
            }
            db.begin();
            ArrayList<SiteNode> siteNodes = new ArrayList<SiteNode>();
            ArrayList<Content> contents = new ArrayList<Content>();
            Hashtable<String, String> allRepositoryProperties = new Hashtable();
            Hashtable<String, String> allSiteNodeProperties = new Hashtable<String, String>();
            Hashtable<String, String> allContentProperties = new Hashtable<String, String>();
            ArrayList<AccessRight> allAccessRights = new ArrayList<AccessRight>();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
            String names = "";
            String[] repositories = this.getRequest().getParameterValues("repositoryId");
            int i = 0;
            while (i < repositories.length) {
                Integer repositoryId = new Integer(repositories[i]);
                Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
                SiteNode siteNode = SiteNodeController.getController().getRootSiteNode(repositoryId, db);
                Content content = ContentController.getContentController().getRootContent(repositoryId, db);
                InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Repository.Read", db);
                if (interceptionPointVO != null) {
                    allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), repository.getId().toString(), db));
                }
                if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Repository.ReadForBinding", db)) != null) {
                    allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), repository.getId().toString(), db));
                }
                this.getContentPropertiesAndAccessRights(ps, allContentProperties, allAccessRights, content, db);
                this.getSiteNodePropertiesAndAccessRights(ps, allSiteNodeProperties, allAccessRights, siteNode, db);
                siteNodes.add(siteNode);
                contents.add(content);
                names = String.valueOf(names) + "_" + repository.getName();
                allRepositoryProperties = this.getRepositoryProperties(ps, repositoryId);
                ++i;
            }
            List contentTypeDefinitions = ContentTypeDefinitionController.getController().getContentTypeDefinitionList(db);
            List categories = CategoryController.getController().findAllActiveCategories();
            InfoGlueExportImpl infoGlueExportImpl = new InfoGlueExportImpl();
            VisualFormatter visualFormatter = new VisualFormatter();
            names = new VisualFormatter().replaceNonAscii(names, '_');
            if (repositories.length > 2 || names.length() > 40) {
                names = repositories.length + "_repositories";
            }
            String fileName = "Export_" + names + "_" + visualFormatter.formatDate(new Date(), "yyyy-MM-dd_HHmm") + ".xml";
            if (this.exportFileName != null && !this.exportFileName.equals("")) {
                fileName = this.exportFileName;
            }
            String filePath = CmsPropertyHandler.getDigitalAssetPath();
            String fileSystemName = String.valueOf(filePath) + File.separator + fileName;
            this.fileUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + fileName;
            this.fileName = fileName;
            String encoding = "UTF-8";
            File file = new File(fileSystemName);
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            Marshaller marshaller = new Marshaller((Writer)osw);
            marshaller.setMapping(map);
            marshaller.setEncoding(encoding);
            DigitalAssetBytesHandler.setMaxSize(this.assetMaxSize);
            infoGlueExportImpl.getRootContent().addAll(contents);
            infoGlueExportImpl.getRootSiteNode().addAll(siteNodes);
            infoGlueExportImpl.setContentTypeDefinitions(contentTypeDefinitions);
            infoGlueExportImpl.setCategories(categories);
            infoGlueExportImpl.setRepositoryProperties(allRepositoryProperties);
            infoGlueExportImpl.setContentProperties(allContentProperties);
            infoGlueExportImpl.setSiteNodeProperties(allSiteNodeProperties);
            infoGlueExportImpl.setAccessRights(allAccessRights);
            marshaller.marshal((Object)infoGlueExportImpl);
            osw.flush();
            osw.close();
            db.rollback();
            db.close();
        }
        catch (Exception e) {
            logger.error((Object)("An error was found exporting a repository: " + e.getMessage()), (Throwable)e);
            db.rollback();
        }
        return "success";
    }

    private void getContentPropertiesAndAccessRights(PropertySet ps, Hashtable<String, String> allContentProperties, List<AccessRight> allAccessRights, Content content, Database db) throws SystemException {
        InterceptionPointVO interceptionPointVO;
        String allowedContentTypeNames = ps.getString("content_" + content.getId() + "_allowedContentTypeNames");
        if (allowedContentTypeNames != null && !allowedContentTypeNames.equals("")) {
            allContentProperties.put("content_" + content.getId() + "_allowedContentTypeNames", allowedContentTypeNames);
        }
        if (ps.exists("content_" + content.getId() + "_defaultContentTypeName")) {
            allContentProperties.put("content_" + content.getId() + "_defaultContentTypeName", ps.getString("content_" + content.getId() + "_defaultContentTypeName"));
        }
        if (ps.exists("content_" + content.getId() + "_initialLanguageId")) {
            allContentProperties.put("content_" + content.getId() + "_initialLanguageId", ps.getString("content_" + content.getId() + "_initialLanguageId"));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Read", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Write", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Create", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Delete", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Move", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.SubmitToPublish", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.ChangeAccessRights", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.CreateVersion", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("ContentVersion.Delete", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("ContentVersion.Write", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("ContentVersion.Read", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("ContentVersion.Publish", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), content.getId().toString(), db));
        }
        for (Content childContent : content.getChildren()) {
            this.getContentPropertiesAndAccessRights(ps, allContentProperties, allAccessRights, childContent, db);
        }
    }

    private void getSiteNodePropertiesAndAccessRights(PropertySet ps, Hashtable<String, String> allSiteNodeProperties, List<AccessRight> allAccessRights, SiteNode siteNode, Database db) throws SystemException, Exception {
        String disabledLanguagesString = ps.getString("siteNode_" + siteNode.getId() + "_disabledLanguages");
        String enabledLanguagesString = ps.getString("siteNode_" + siteNode.getId() + "_enabledLanguages");
        if (disabledLanguagesString != null && !disabledLanguagesString.equals("") && !disabledLanguagesString.equals("null")) {
            allSiteNodeProperties.put("siteNode_" + siteNode.getId() + "_disabledLanguages", disabledLanguagesString);
        }
        if (enabledLanguagesString != null && !enabledLanguagesString.equals("") && !enabledLanguagesString.equals("null")) {
            allSiteNodeProperties.put("siteNode_" + siteNode.getId() + "_enabledLanguages", enabledLanguagesString);
        }
        SiteNodeVersionVO latestSiteNodeVersionVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionVO(db, siteNode.getId());
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.Read", db);
        if (interceptionPointVO != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.Write", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.CreateSiteNode", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.DeleteSiteNode", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.MoveSiteNode", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.SubmitToPublish", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.ChangeAccessRights", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("SiteNodeVersion.Publish", db)) != null) {
            allAccessRights.addAll(AccessRightController.getController().getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), latestSiteNodeVersionVO.getId().toString(), db));
        }
        for (SiteNode childSiteNode : siteNode.getChildSiteNodes()) {
            this.getSiteNodePropertiesAndAccessRights(ps, allSiteNodeProperties, allAccessRights, childSiteNode, db);
        }
    }

    private Hashtable<String, String> getRepositoryProperties(PropertySet ps, Integer repositoryId) throws Exception {
        byte[] extraPropertiesBytes;
        byte[] StylesXMLBytes;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        byte[] WYSIWYGConfigBytes = ps.getData("repository_" + repositoryId + "_WYSIWYGConfig");
        if (WYSIWYGConfigBytes != null) {
            properties.put("repository_" + repositoryId + "_WYSIWYGConfig", new String(WYSIWYGConfigBytes, "utf-8"));
        }
        if ((StylesXMLBytes = ps.getData("repository_" + repositoryId + "_StylesXML")) != null) {
            properties.put("repository_" + repositoryId + "_StylesXML", new String(StylesXMLBytes, "utf-8"));
        }
        if ((extraPropertiesBytes = ps.getData("repository_" + repositoryId + "_extraProperties")) != null) {
            properties.put("repository_" + repositoryId + "_extraProperties", new String(extraPropertiesBytes, "utf-8"));
        }
        if (ps.exists("repository_" + repositoryId + "_defaultFolderContentTypeName")) {
            properties.put("repository_" + repositoryId + "_defaultFolderContentTypeName", ps.getString("repository_" + repositoryId + "_defaultFolderContentTypeName"));
        }
        if (ps.exists("repository_" + repositoryId + "_defaultTemplateRepository")) {
            properties.put("repository_" + repositoryId + "_defaultTemplateRepository", ps.getString("repository_" + repositoryId + "_defaultTemplateRepository"));
        }
        if (ps.exists("repository_" + repositoryId + "_parentRepository")) {
            properties.put("repository_" + repositoryId + "_parentRepository", ps.getString("repository_" + repositoryId + "_parentRepository"));
        }
        return properties;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public int getAssetMaxSize() {
        return this.assetMaxSize;
    }

    public void setAssetMaxSize(int assetMaxSize) {
        this.assetMaxSize = assetMaxSize;
    }
}

