/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;

public class DeleteSystemUserAction
extends InfoGlueAbstractAction {
    private SystemUserVO systemUserVO;

    public DeleteSystemUserAction() {
        this(new SystemUserVO());
    }

    public DeleteSystemUserAction(SystemUserVO systemUserVO) {
        this.systemUserVO = systemUserVO;
    }

    protected String doExecute() throws Exception {
        if (this.systemUserVO.getUserName().equals(CmsPropertyHandler.getAnonymousUser())) {
            throw new SystemException("You must not remove the anonymous user as it's needed by the system.");
        }
        UserControllerProxy.getController().deleteUser(this.systemUserVO.getUserName());
        return "success";
    }

    public String doV3() throws Exception {
        this.doExecute();
        return "successV3";
    }

    public void setUserName(String userName) {
        this.systemUserVO.setUserName(userName);
    }

    public String getUserName() {
        return this.systemUserVO.getUserName();
    }
}

