/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

public class DeleteRepositoryAction
extends InfoGlueAbstractAction {
    private RepositoryVO repositoryVO;
    private Integer repositoryId;
    private String returnAddress = null;

    public DeleteRepositoryAction() {
        this(new RepositoryVO());
    }

    public DeleteRepositoryAction(RepositoryVO repositoryVO) {
        this.repositoryVO = repositoryVO;
    }

    protected String doExecute() throws ConstraintException, Exception {
        boolean hasAccessToManagementTool = this.hasAccessTo("ManagementTool.Read");
        if (!hasAccessToManagementTool) {
            throw new AccessConstraintException("Repository.delete", "1003");
        }
        this.repositoryVO.setRepositoryId(this.getRepositoryId());
        try {
            RepositoryController.getController().delete(this.repositoryVO, this.getInfoGluePrincipal().getName(), this.getInfoGluePrincipal());
            return "success";
        }
        catch (ConstraintException ce) {
            this.returnAddress = "ViewRepository.action?repositoryId=" + this.repositoryVO.getId();
            if (ce.getErrorCode().equals("3300") && ce.getFieldName().equals("ContentVersion.stateId")) {
                throw new ConstraintException("ContentVersion.stateId", "3307", ce.getExtraInformation());
            }
            if (ce.getErrorCode().equals("3400") && ce.getFieldName().equals("SiteNodeVersion.stateId")) {
                throw new ConstraintException("ContentVersion.stateId", "3406", ce.getExtraInformation());
            }
            throw ce;
        }
    }

    public String doExecuteByForce() throws ConstraintException, Exception {
        boolean hasAccessToManagementTool = this.hasAccessTo("ManagementTool.Read");
        if (!hasAccessToManagementTool) {
            throw new AccessConstraintException("Repository.delete", "1003");
        }
        this.repositoryVO.setRepositoryId(this.getRepositoryId());
        try {
            RepositoryController.getController().delete(this.repositoryVO, this.getInfoGluePrincipal().getName(), true, this.getInfoGluePrincipal());
            return "success";
        }
        catch (ConstraintException ce) {
            this.returnAddress = "ViewRepository.action?repositoryId=" + this.repositoryVO.getId();
            if (ce.getErrorCode().equals("3300") && ce.getFieldName().equals("ContentVersion.stateId")) {
                throw new ConstraintException("ContentVersion.stateId", "3307", ce.getExtraInformation());
            }
            if (ce.getErrorCode().equals("3400") && ce.getFieldName().equals("SiteNodeVersion.stateId")) {
                throw new ConstraintException("ContentVersion.stateId", "3406", ce.getExtraInformation());
            }
            throw ce;
        }
    }

    public void setRepositoryId(Integer repositoryId) throws SystemException {
        this.repositoryVO.setRepositoryId(repositoryId);
    }

    public Integer getRepositoryId() {
        return this.repositoryVO.getRepositoryId();
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }
}

