/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateSystemUserAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateSystemUserAction.class.getName());
    private static final long serialVersionUID = 1L;
    private ConstraintExceptionBuffer ceb;
    private SystemUserVO systemUserVO;
    private InfoGluePrincipal infoGluePrincipal;
    private List availableRoles = new ArrayList();
    private List availableGroups = new ArrayList();
    private List contentTypeDefinitionVOList;

    public CreateSystemUserAction() {
        this(new SystemUserVO());
    }

    public CreateSystemUserAction(SystemUserVO systemUserVO) {
        this.systemUserVO = systemUserVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doInput() throws Exception {
        this.availableRoles = RoleControllerProxy.getController().getAvailableRoles(this.getInfoGluePrincipal(), "Role.ManageUsers");
        this.availableGroups = GroupControllerProxy.getController().getAvailableGroups(this.getInfoGluePrincipal(), "Group.ManageUsers");
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_USER_PROPERTIES);
        return "input";
    }

    public String doInputV3() throws Exception {
        this.availableRoles = RoleControllerProxy.getController().getAvailableRoles(this.getInfoGluePrincipal(), "Role.ManageUsers");
        this.availableGroups = GroupControllerProxy.getController().getAvailableGroups(this.getInfoGluePrincipal(), "Group.ManageUsers");
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_USER_PROPERTIES);
        return "inputV3";
    }

    public String doExecute() throws Exception {
        this.ceb = this.systemUserVO.validate();
        this.ceb.throwIfNotEmpty();
        String[] roles = this.getRequest().getParameterValues("roleName");
        String[] groups = this.getRequest().getParameterValues("groupName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        logger.info((Object)("roles:" + roles));
        logger.info((Object)("groups:" + groups));
        logger.info((Object)("contentTypeDefinitionIds:" + contentTypeDefinitionIds));
        this.infoGluePrincipal = UserControllerProxy.getController().createUser(this.systemUserVO);
        if (roles != null && groups != null) {
            UserControllerProxy.getController().updateUser(this.systemUserVO, roles, groups);
        }
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            UserPropertiesController.getController().updateContentTypeDefinitions(this.getUserName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doV3() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException e) {
            this.availableRoles = RoleControllerProxy.getController().getAvailableRoles(this.getInfoGluePrincipal(), "Role.ManageUsers");
            this.availableGroups = GroupControllerProxy.getController().getAvailableGroups(this.getInfoGluePrincipal(), "Group.ManageUsers");
            this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_USER_PROPERTIES);
            e.setResult("inputV3");
            throw e;
        }
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        this.doV3();
        return "successSaveAndExitV3";
    }

    public void setuserName(String userName) {
        this.systemUserVO.setUserName(userName);
    }

    public String getUserName() {
        return this.systemUserVO.getUserName();
    }

    public String getFirstName() {
        return this.systemUserVO.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.systemUserVO.setFirstName(firstName);
    }

    public String getLastName() {
        return this.systemUserVO.getLastName();
    }

    public void setLastName(String lastName) {
        this.systemUserVO.setLastName(lastName);
    }

    public String getEmail() {
        return this.systemUserVO.getEmail();
    }

    public void setEmail(String email) {
        this.systemUserVO.setEmail(email);
    }

    public String getPassword() {
        return this.systemUserVO.getPassword();
    }

    public void setPassword(String password) {
        this.systemUserVO.setPassword(password);
    }

    public List getAvailableRoles() {
        return this.availableRoles;
    }

    public List getAvailableGroups() {
        return this.availableGroups;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }
}

