/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceDefinitionController;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateServiceDefinitionAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private ServiceDefinitionVO serviceDefinitionVO;
    private ConstraintExceptionBuffer ceb;
    private String name;
    private String description;
    private String className;

    public CreateServiceDefinitionAction() {
        this(new ServiceDefinitionVO());
    }

    public CreateServiceDefinitionAction(ServiceDefinitionVO serviceDefinitionVO) {
        this.serviceDefinitionVO = serviceDefinitionVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.serviceDefinitionVO.getName();
    }

    public void setName(String name) {
        try {
            this.serviceDefinitionVO.setName(name);
        }
        catch (ConstraintException ce) {
            this.name = name;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.serviceDefinitionVO.getDescription();
    }

    public void setDescription(String description) {
        try {
            this.serviceDefinitionVO.setDescription(description);
        }
        catch (ConstraintException ce) {
            this.description = description;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        return this.serviceDefinitionVO.getClassName();
    }

    public void setClassName(String className) {
        try {
            this.serviceDefinitionVO.setClassName(className);
        }
        catch (ConstraintException ce) {
            this.className = className;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String doExecute() throws Exception {
        this.ceb.add(this.serviceDefinitionVO.validate());
        this.ceb.throwIfNotEmpty();
        ServiceDefinitionVO serviceDefinitionVO = ServiceDefinitionController.getController().create(this.serviceDefinitionVO);
        return "success";
    }

    public String doInput() throws Exception {
        return "input";
    }
}

