/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateRoleAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private RoleVO roleVO;
    private InfoGlueRole infoGlueRole;
    private List infoGluePrincipals = new ArrayList();
    private List contentTypeDefinitionVOList;
    private ConstraintExceptionBuffer ceb;

    public CreateRoleAction() {
        this(new RoleVO());
    }

    public CreateRoleAction(RoleVO RoleVO2) {
        this.roleVO = RoleVO2;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doInput() throws Exception {
        return "input";
    }

    public String doInputV3() throws Exception {
        this.infoGluePrincipals = UserControllerProxy.getController().getAllUsers();
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_ROLE_PROPERTIES);
        return "inputV3";
    }

    protected String doExecute() throws Exception {
        this.ceb.add(this.roleVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] userNames = this.getRequest().getParameterValues("userName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        this.infoGlueRole = RoleControllerProxy.getController().createRole(this.roleVO);
        if (userNames != null) {
            RoleControllerProxy.getController().updateRole(this.roleVO, userNames);
        }
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            RolePropertiesController.getController().updateContentTypeDefinitions(this.getRoleName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doV3() throws Exception {
        try {
            this.doExecute();
            String[] interceptionPointNames = new String[]{"Role.ManageUsers", "Role.ManageAccessRights", "Role.ReadForAssignment"};
            AccessRightController.getController().addUserRights(interceptionPointNames, this.getRoleName(), this.getInfoGluePrincipal());
        }
        catch (ConstraintException e) {
            this.infoGluePrincipals = UserControllerProxy.getController().getAllUsers();
            this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_ROLE_PROPERTIES);
            e.setResult("inputV3");
            throw e;
        }
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        this.doV3();
        return "successSaveAndExitV3";
    }

    public void setRoleName(String roleName) {
        this.roleVO.setRoleName(roleName);
    }

    public String getRoleName() {
        return this.roleVO.getRoleName();
    }

    public void setDescription(String description) {
        this.roleVO.setDescription(description);
    }

    public String getDescription() {
        return this.roleVO.getDescription();
    }

    public List getInfoGluePrincipals() {
        return this.infoGluePrincipals;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }
}

