/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateLanguageAction
extends InfoGlueAbstractAction {
    private Integer languageId;
    private String name;
    private String languageCode;
    private String charset;
    private ConstraintExceptionBuffer ceb;
    private LanguageVO languageVO;

    public CreateLanguageAction() {
        this(new LanguageVO());
    }

    public CreateLanguageAction(LanguageVO languageVO) {
        this.languageVO = languageVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.languageVO.getName();
    }

    public void setName(String name) {
        try {
            this.languageVO.setName(name);
        }
        catch (ConstraintException ce) {
            this.name = name;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getLanguageCode() {
        if (this.languageCode != null) {
            return this.languageCode;
        }
        return this.languageVO.getLanguageCode();
    }

    public void setLanguageCode(String languageCode) {
        try {
            this.languageVO.setLanguageCode(languageCode);
        }
        catch (ConstraintException ce) {
            this.languageCode = languageCode;
            this.ceb.add(new ConstraintExceptionBuffer(ce));
        }
    }

    public String getCharset() {
        return this.languageVO.getCharset();
    }

    public void setCharset(String charset) {
        this.languageVO.setCharset(charset);
    }

    public String doExecute() throws Exception {
        this.ceb.add(this.languageVO.validate());
        this.ceb.throwIfNotEmpty();
        LanguageVO languageVO = LanguageController.getController().create(this.languageVO);
        return "success";
    }

    public String doInput() throws Exception {
        return "input";
    }
}

