/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class CreateInterceptionPointAction
extends InfoGlueAbstractAction {
    private ConstraintExceptionBuffer ceb;
    private InterceptionPointVO interceptionPointVO;
    private String interceptionPointVOName;
    private List<InterceptionPointVO> inactiveInterceptionPointVOList = null;

    public CreateInterceptionPointAction() {
        this(new InterceptionPointVO());
    }

    public CreateInterceptionPointAction(InterceptionPointVO interceptionPointVO) {
        this.interceptionPointVO = interceptionPointVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        if (this.interceptionPointVOName != null && !this.interceptionPointVOName.equals("")) {
            this.interceptionPointVO = (InterceptionPointVO)InterceptionPointController.systemInterceptionPoints.get(this.interceptionPointVOName);
        }
        this.ceb.add(this.interceptionPointVO.validate());
        this.ceb.throwIfNotEmpty();
        this.interceptionPointVO = InterceptionPointController.getController().create(this.interceptionPointVO);
        return "success";
    }

    public String doInput() throws Exception {
        this.inactiveInterceptionPointVOList = InterceptionPointController.getController().getInactiveInterceptionPointVOList();
        Collections.sort(this.inactiveInterceptionPointVOList, new ReflectionComparator("name"));
        return "input";
    }

    public Integer getInterceptionPointId() {
        return this.interceptionPointVO.getInterceptionPointId();
    }

    public String getCategory() {
        return this.interceptionPointVO.getCategory();
    }

    public void setCategory(String category) {
        this.interceptionPointVO.setCategory(category);
    }

    public String getDescription() {
        return this.interceptionPointVO.getDescription();
    }

    public void setDescription(String description) {
        this.interceptionPointVO.setDescription(description);
    }

    public String getName() {
        return this.interceptionPointVO.getName();
    }

    public void setName(String name) {
        this.interceptionPointVO.setName(name);
    }

    public Boolean getUsesExtraDataForAccessControl() {
        return this.interceptionPointVO.getUsesExtraDataForAccessControl();
    }

    public void setUsesExtraDataForAccessControl(Boolean usesExtraDataForAccessControl) {
        this.interceptionPointVO.setUsesExtraDataForAccessControl(usesExtraDataForAccessControl);
    }

    public Collection getInactiveInterceptionPointVOList() {
        return this.inactiveInterceptionPointVOList;
    }

    public String getInterceptionPointVOName() {
        return this.interceptionPointVOName;
    }

    public void setInterceptionPointVOName(String interceptionPointVOName) {
        this.interceptionPointVOName = interceptionPointVOName;
    }
}

