/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateGroupAction
extends InfoGlueAbstractAction {
    private GroupVO groupVO;
    private InfoGlueGroup infoGlueGroup;
    private List infoGluePrincipals = new ArrayList();
    private List contentTypeDefinitionVOList;
    private ConstraintExceptionBuffer ceb;

    public CreateGroupAction() {
        this(new GroupVO());
    }

    public CreateGroupAction(GroupVO GroupVO2) {
        this.groupVO = GroupVO2;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doInput() throws Exception {
        return "input";
    }

    public String doInputV3() throws Exception {
        this.infoGluePrincipals = UserControllerProxy.getController().getAllUsers();
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_GROUP_PROPERTIES);
        return "inputV3";
    }

    protected String doExecute() throws Exception {
        this.ceb.add(this.groupVO.validate());
        this.ceb.throwIfNotEmpty();
        String[] userNames = this.getRequest().getParameterValues("userName");
        String[] contentTypeDefinitionIds = this.getRequest().getParameterValues("contentTypeDefinitionId");
        this.infoGlueGroup = GroupControllerProxy.getController().createGroup(this.groupVO);
        if (userNames != null) {
            GroupControllerProxy.getController().updateGroup(this.groupVO, userNames);
        }
        if (contentTypeDefinitionIds != null && contentTypeDefinitionIds.length > 0 && !contentTypeDefinitionIds[0].equals("")) {
            GroupPropertiesController.getController().updateContentTypeDefinitions(this.getGroupName(), contentTypeDefinitionIds);
        }
        return "success";
    }

    public String doV3() throws Exception {
        try {
            this.doExecute();
            String[] interceptionPointNames = new String[]{"Group.ManageUsers", "Group.ManageAccessRights", "Group.ReadForAssignment"};
            AccessRightController.getController().addUserRights(interceptionPointNames, this.getGroupName(), this.getInfoGluePrincipal());
        }
        catch (ConstraintException e) {
            this.infoGluePrincipals = UserControllerProxy.getController().getAllUsers();
            this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.EXTRANET_ROLE_PROPERTIES);
            e.setResult("inputV3");
            throw e;
        }
        return "successV3";
    }

    public String doSaveAndExitV3() throws Exception {
        this.doV3();
        return "successSaveAndExitV3";
    }

    public void setGroupName(String groupName) {
        this.groupVO.setGroupName(groupName);
    }

    public String getGroupName() {
        return this.groupVO.getGroupName();
    }

    public void setDescription(String description) {
        this.groupVO.setDescription(description);
    }

    public String getDescription() {
        return this.groupVO.getDescription();
    }

    public List getInfoGluePrincipals() {
        return this.infoGluePrincipals;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }
}

