/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.MailServiceFactory;

public class CreateEmailAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateEmailAction.class.getName());
    private static final long serialVersionUID = 1L;
    private List users = null;
    private List roles = null;
    private List groups = null;
    private String[] userNames;
    private String[] roleNames;
    private String[] groupNames;
    private String usersAddresses = "";
    private String recipients;
    private String from;
    private String subject;
    private String message;
    private String extraText;
    private String extraTextProperty;
    private String errorMessage = "";
    private String returnAddress;
    private String originalUrl;
    private String userSessionKey;

    public String doExecute() throws Exception {
        if (this.recipients != null && this.recipients.length() > 0 && this.subject != null && this.subject.length() > 0 && this.message != null && this.message.length() > 0) {
            String contentType;
            if (this.from == null || this.from.length() == 0) {
                String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
                if (systemEmailSender == null || systemEmailSender.equalsIgnoreCase("")) {
                    systemEmailSender = "InfoGlueCMS@" + CmsPropertyHandler.getMailSmtpHost();
                }
                this.from = systemEmailSender;
            }
            if ((contentType = CmsPropertyHandler.getMailContentType()) == null || contentType.length() == 0) {
                contentType = "text/html";
            }
            if (contentType.equalsIgnoreCase("text/html")) {
                VisualFormatter ui = new VisualFormatter();
                this.message = ui.escapeHTMLforXMLService(this.message);
                this.message = "<div>" + this.message.replaceAll("\n", "<br/>\n") + "</div>";
            }
        } else {
            this.errorMessage = "Must enter information in all fields below.";
            return "inputCreateEmail";
        }
        MailServiceFactory.getService().sendEmail(this.from, this.from, this.recipients, this.subject, this.message, "utf-8");
        return "success";
    }

    public String doInputChooseRecipients() throws Exception {
        this.users = UserControllerProxy.getController().getAllUsers();
        this.roles = RoleControllerProxy.getController().getAllRoles();
        this.groups = GroupControllerProxy.getController().getAllGroups();
        return "inputChooseRecipients";
    }

    public String doInputCreateEmail() throws Exception {
        List principals;
        int i;
        this.userNames = this.getRequest().getParameterValues("userName");
        this.roleNames = this.getRequest().getParameterValues("roleName");
        this.groupNames = this.getRequest().getParameterValues("groupName");
        if (this.userNames != null) {
            i = 0;
            while (i < this.userNames.length) {
                String userName = this.userNames[i];
                InfoGluePrincipal principal = UserControllerProxy.getController().getUser(userName);
                if (this.usersAddresses.indexOf(principal.getEmail()) == -1) {
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        if (this.roleNames != null) {
            i = 0;
            while (i < this.roleNames.length) {
                String roleName = this.roleNames[i];
                principals = RoleControllerProxy.getController().getInfoGluePrincipals(roleName);
                for (InfoGluePrincipal principal : principals) {
                    if (this.usersAddresses.indexOf(principal.getEmail()) != -1) continue;
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        if (this.groupNames != null) {
            i = 0;
            while (i < this.groupNames.length) {
                String groupName = this.groupNames[i];
                principals = GroupControllerProxy.getController().getInfoGluePrincipals(groupName);
                for (InfoGluePrincipal principal : principals) {
                    if (this.usersAddresses.indexOf(principal.getEmail()) != -1) continue;
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        return "inputCreateEmail";
    }

    public String doExecuteV3() throws Exception {
        String contentType;
        VisualFormatter ui = new VisualFormatter();
        this.extraText = this.getRequest().getParameter("extraText");
        this.extraTextProperty = this.getRequest().getParameter("extraTextProperty");
        if (this.subject == null || this.subject.length() == 0 || this.message == null || this.message.length() == 0) {
            this.usersAddresses = this.getRequest().getParameter("recipients");
            this.errorMessage = "Must enter information in all fields below.";
            return "inputCreateEmailV3";
        }
        if (this.from == null || this.from.length() == 0) {
            String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
            if (systemEmailSender == null || systemEmailSender.equalsIgnoreCase("")) {
                systemEmailSender = "InfoGlueCMS@" + CmsPropertyHandler.getMailSmtpHost();
            }
            this.from = systemEmailSender;
        }
        if ((contentType = CmsPropertyHandler.getMailContentType()) == null || contentType.length() == 0) {
            contentType = "text/html";
        }
        logger.error((Object)("message:" + this.message));
        if (contentType.equalsIgnoreCase("text/html")) {
            this.message = ui.escapeHTMLforXMLService(this.message);
            this.message = "<div>" + this.message.replaceAll("\n", "<br/>\n") + "</div>";
        }
        if (this.extraText != null && !this.extraText.equals("")) {
            this.message = String.valueOf(this.message) + "<br/>";
            this.message = String.valueOf(this.message) + this.extraText;
        }
        if (this.extraTextProperty != null && !this.extraTextProperty.equals("")) {
            this.message = String.valueOf(this.message) + this.getLocalizedString(this.getLocale(), this.extraTextProperty, this.originalUrl);
        }
        MailServiceFactory.getService().sendEmail(this.from, this.from, this.recipients, this.subject, this.message, "utf-8");
        if (this.returnAddress != null && !this.returnAddress.equals("")) {
            String arguments = "userSessionKey=" + this.userSessionKey + "&isAutomaticRedirect=false";
            String messageUrl = String.valueOf(this.returnAddress) + (this.returnAddress.indexOf("?") > -1 ? "&" : "?") + arguments;
            this.getResponse().sendRedirect(messageUrl);
            return "none";
        }
        return "successV3";
    }

    public String doInputChooseRecipientsV3() throws Exception {
        this.extraText = this.getRequest().getParameter("extraText");
        this.users = UserControllerProxy.getController().getAllUsers();
        this.roles = RoleControllerProxy.getController().getAllRoles();
        this.groups = GroupControllerProxy.getController().getAllGroups();
        this.userSessionKey = "" + System.currentTimeMillis();
        this.setActionMessage(this.userSessionKey, "Notifiering skickad.");
        return "inputChooseRecipientsV3";
    }

    public String doInputCreateEmailV3() throws Exception {
        List principals;
        int i;
        this.extraText = this.getRequest().getParameter("extraText");
        this.userNames = this.getRequest().getParameterValues("userName");
        this.roleNames = this.getRequest().getParameterValues("roleName");
        this.groupNames = this.getRequest().getParameterValues("groupName");
        if (this.userNames == null && this.roleNames == null && this.groupNames == null) {
            this.errorMessage = "You must select at least one recipient.";
            this.users = UserControllerProxy.getController().getAllUsers();
            this.roles = RoleControllerProxy.getController().getAllRoles();
            this.groups = GroupControllerProxy.getController().getAllGroups();
            return "inputChooseRecipientsV3";
        }
        if (this.userNames != null) {
            i = 0;
            while (i < this.userNames.length) {
                String userName = this.userNames[i];
                InfoGluePrincipal principal = UserControllerProxy.getController().getUser(userName);
                if (this.usersAddresses.indexOf(principal.getEmail()) == -1) {
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        if (this.roleNames != null) {
            i = 0;
            while (i < this.roleNames.length) {
                String roleName = this.roleNames[i];
                principals = RoleControllerProxy.getController().getInfoGluePrincipals(roleName);
                for (InfoGluePrincipal principal : principals) {
                    if (this.usersAddresses.indexOf(principal.getEmail()) != -1) continue;
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        if (this.groupNames != null) {
            i = 0;
            while (i < this.groupNames.length) {
                String groupName = this.groupNames[i];
                principals = GroupControllerProxy.getController().getInfoGluePrincipals(groupName);
                for (InfoGluePrincipal principal : principals) {
                    if (this.usersAddresses.indexOf(principal.getEmail()) != -1) continue;
                    if (this.usersAddresses.length() > 0) {
                        this.usersAddresses = String.valueOf(this.usersAddresses) + ";";
                    }
                    this.usersAddresses = String.valueOf(this.usersAddresses) + principal.getEmail();
                }
                ++i;
            }
        }
        return "inputCreateEmailV3";
    }

    public List getGroups() {
        return this.groups;
    }

    public List getRoles() {
        return this.roles;
    }

    public List getUsers() {
        return this.users;
    }

    public String getUsersAddresses() {
        return this.usersAddresses;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public void setExtraText(String extraText) {
        this.extraText = extraText;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getUserSessionKey() {
        return this.userSessionKey;
    }

    public void setUserSessionKey(String userSessionKey) {
        this.userSessionKey = userSessionKey;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getExtraTextProperty() {
        return this.extraTextProperty;
    }

    public void setExtraTextProperty(String extraTextProperty) {
        this.extraTextProperty = extraTextProperty;
    }
}

