/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateContentTypeDefinitionAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateContentTypeDefinitionAction.class.getName());
    private static final long serialVersionUID = 1L;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private ConstraintExceptionBuffer ceb;
    private String name;
    private String description;

    public CreateContentTypeDefinitionAction() {
        this(new ContentTypeDefinitionVO());
    }

    public CreateContentTypeDefinitionAction(ContentTypeDefinitionVO contentTypeDefinitionVO) {
        this.contentTypeDefinitionVO = contentTypeDefinitionVO;
        String schemaValue = "";
        try {
            schemaValue = FileHelper.getStreamAsString(this.getClass().getResourceAsStream("/org/infoglue/cms/applications/defaultContentTypeDefinition.xml"));
        }
        catch (Exception e) {
            logger.error((Object)("The system could not find the default content type definition:" + e.getMessage()), (Throwable)e);
        }
        this.contentTypeDefinitionVO.setSchemaValue(schemaValue);
        this.ceb = new ConstraintExceptionBuffer();
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionVO.getContentTypeDefinitionId();
    }

    public String getName() {
        return this.contentTypeDefinitionVO.getName();
    }

    public void setName(String name) {
        this.contentTypeDefinitionVO.setName(name);
    }

    public String doExecute() throws Exception {
        this.ceb.add(this.contentTypeDefinitionVO.validate());
        this.ceb.throwIfNotEmpty();
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().create(this.contentTypeDefinitionVO);
        return "success";
    }

    public String doInput() throws Exception {
        return "input";
    }

    public Integer getType() {
        return this.contentTypeDefinitionVO.getType();
    }

    public void setType(Integer type) {
        this.contentTypeDefinitionVO.setType(type);
    }
}

