/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.ModelAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.entities.kernel.Persistent;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

public class CategoryAction
extends ModelAction {
    private static final Logger logger = Logger.getLogger((String)CategoryAction.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String MAIN = "main";
    private CategoryController controller = CategoryController.getController();
    private ContentCategoryController contentCategoryController = ContentCategoryController.getController();
    private boolean forceDelete = false;

    protected Persistent createModel() {
        return new CategoryVO();
    }

    public CategoryVO getCategory() {
        return (CategoryVO)this.getModel();
    }

    public Integer getCategoryId() {
        return this.getCategory().getCategoryId();
    }

    public void setCategoryId(Integer i) {
        this.getCategory().setCategoryId(i);
    }

    public List getReferences() throws Exception {
        return this.contentCategoryController.findByCategory(this.getCategoryId());
    }

    public String doList() throws SystemException {
        this.setModels(this.controller.findRootCategories());
        return "success";
    }

    public String doNew() throws SystemException {
        return "success";
    }

    public String doEdit() throws SystemException {
        this.setModel(this.controller.findWithChildren(this.getCategoryId()));
        return "success";
    }

    public String doDisplayTreeForMove() throws SystemException {
        return "success";
    }

    public String doMove() throws SystemException {
        this.setModel(this.controller.moveCategory(this.getCategoryId(), this.getCategory().getParentId()));
        return "success";
    }

    public String doSave() throws SystemException, ConstraintException {
        this.validateModel();
        this.setModel(this.controller.save(this.getCategory()));
        return this.getCategory().isRoot() ? MAIN : "success";
    }

    public String doDelete() throws Exception {
        List references = new ArrayList();
        try {
            references = this.getReferences();
        }
        catch (Exception e) {
            logger.error((Object)("Error getting references:" + e.getMessage()));
        }
        if (references.size() > 0 && !this.forceDelete) {
            throw new ConstraintException("Category.name", "3608");
        }
        this.setModel(this.controller.findById(this.getCategoryId()));
        this.controller.delete(this.getCategoryId());
        return this.getCategory().getParentId() == null ? MAIN : "success";
    }

    public String doExecute() throws Exception {
        return "success";
    }

    public void setForceDelete(boolean forceDelete) {
        this.forceDelete = forceDelete;
    }
}

