/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.managementtool.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightGroup;
import org.infoglue.cms.entities.management.AccessRightGroupVO;
import org.infoglue.cms.entities.management.AccessRightRole;
import org.infoglue.cms.entities.management.AccessRightRoleVO;
import org.infoglue.cms.entities.management.AccessRightUser;
import org.infoglue.cms.entities.management.AccessRightUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;

public class AuthorizationSwitchManagementAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)AuthorizationSwitchManagementAction.class.getName());
    private List invalidUsers = new ArrayList();
    private List invalidRoles = new ArrayList();
    private List invalidGroups = new ArrayList();
    private List users = new ArrayList();
    private List roles = new ArrayList();
    private List groups = new ArrayList();
    private List accessRights = new ArrayList();
    private String userName;
    private String roleName;
    private String groupName;
    private String newUserName;
    private String newRoleName;
    private String newGroupName;

    public String doInputUser() throws Exception {
        this.users = UserControllerProxy.getController().getAllUsers();
        this.accessRights = this.getAccessRightsUser();
        return "inputUser";
    }

    public String doInputRole() throws Exception {
        this.roles = RoleControllerProxy.getController().getAllRoles();
        this.accessRights = this.getAccessRightsRole();
        return "inputRole";
    }

    public String doInputGroup() throws Exception {
        this.groups = GroupControllerProxy.getController().getAllGroups();
        this.accessRights = this.getAccessRightsGroup();
        return "inputGroup";
    }

    public String doUpdateUser() throws Exception {
        if (!this.getInfoGluePrincipal().getIsAdministrator()) {
            throw new SystemException("You are not allowed to perform this action.");
        }
        this.updateAccessRightsUser(this.userName, this.newUserName);
        return "successUser";
    }

    public String doUpdateRole() throws Exception {
        if (!this.getInfoGluePrincipal().getIsAdministrator()) {
            throw new SystemException("You are not allowed to perform this action.");
        }
        this.updateAccessRightsRole(this.roleName, this.newRoleName);
        return "successRole";
    }

    public String doUpdateGroup() throws Exception {
        if (!this.getInfoGluePrincipal().getIsAdministrator()) {
            throw new SystemException("You are not allowed to perform this action.");
        }
        this.updateAccessRightsGroup(this.groupName, this.newGroupName);
        return "successGroup";
    }

    public String doExecute() throws Exception {
        return "success";
    }

    private List getAccessRightsUser() throws Exception {
        List accessRightUserList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    accessRightUserList = AccessRightController.getController().getAccessRightUserList(this.userName, db);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
        return accessRightUserList;
    }

    private List getAccessRightsRole() throws Exception {
        List accessRightRoleList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    accessRightRoleList = AccessRightController.getController().getAccessRightRoleList(this.roleName, db, false);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                try {
                    db.rollback();
                }
                catch (Exception e2) {
                    logger.error((Object)("An error occurred so we should not complete the transaction:" + e2.getMessage()));
                }
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            try {
                db.close();
            }
            catch (Exception e2) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e2.getMessage()));
            }
        }
        return accessRightRoleList;
    }

    private List getAccessRightsGroup() throws Exception {
        List accessRightGroupList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    accessRightGroupList = AccessRightController.getController().getAccessRightGroupList(this.groupName, db);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
        return accessRightGroupList;
    }

    private List getInvalidAccessRightsUser() throws Exception {
        HashSet<String> invalidUsers = new HashSet<String>();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    List users = UserControllerProxy.getController(db).getAllUsers();
                    List systemUserVOList = AccessRightController.getController().getAccessRightUserVOList(db);
                    for (AccessRightUserVO accessRightUserVO : systemUserVOList) {
                        boolean isValid = false;
                        for (InfoGluePrincipal principal : users) {
                            if (!principal.getName().equalsIgnoreCase(accessRightUserVO.getUserName())) continue;
                            isValid = true;
                            break;
                        }
                        if (isValid) continue;
                        invalidUsers.add(accessRightUserVO.getUserName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
        ArrayList<String> invalidUsersList = new ArrayList<String>();
        invalidUsersList.addAll(invalidUsers);
        return invalidUsersList;
    }

    private List getInvalidAccessRightsRole() throws Exception {
        HashSet<String> invalidRoles = new HashSet<String>();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                String name = "AccessRightRole names";
                String description = "Checks if the Role names given exists in the current authorizationModule.";
                try {
                    List users = RoleControllerProxy.getController(db).getAllRoles();
                    List systemRoleVOList = AccessRightController.getController().getAccessRightRoleVOList(db);
                    for (AccessRightRoleVO accessRightRoleVO : systemRoleVOList) {
                        boolean isValid = false;
                        for (InfoGlueRole role : users) {
                            if (!role.getName().equalsIgnoreCase(accessRightRoleVO.getRoleName())) continue;
                            isValid = true;
                            break;
                        }
                        if (isValid) continue;
                        invalidRoles.add(accessRightRoleVO.getRoleName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
        ArrayList<String> invalidRolesList = new ArrayList<String>();
        invalidRolesList.addAll(invalidRoles);
        return invalidRolesList;
    }

    private List getInvalidAccessRightsGroup() throws Exception {
        HashSet<String> invalidGroups = new HashSet<String>();
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                String name = "AccessRightGroup names";
                String description = "Checks if the user names given exists in the current authorizationModule.";
                try {
                    List users = GroupControllerProxy.getController(db).getAllGroups();
                    List systemGroupVOList = AccessRightController.getController().getAccessRightGroupVOList(db);
                    for (AccessRightGroupVO accessRightGroupVO : systemGroupVOList) {
                        boolean isValid = false;
                        for (InfoGlueGroup group : users) {
                            if (!group.getName().equalsIgnoreCase(accessRightGroupVO.getGroupName())) continue;
                            isValid = true;
                            break;
                        }
                        if (isValid) continue;
                        invalidGroups.add(accessRightGroupVO.getGroupName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
        ArrayList invalidGroupsList = new ArrayList();
        invalidGroupsList.addAll(invalidGroupsList);
        return invalidGroupsList;
    }

    private void updateAccessRightsUser(String userName, String newUserName) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    List accessRightUserList = AccessRightController.getController().getAccessRightUserList(userName, db);
                    for (AccessRightUser accessRightUser : accessRightUserList) {
                        AccessRight accessRight = accessRightUser.getAccessRight();
                        boolean exists = false;
                        for (AccessRightUser currentAccessRightUser : accessRight.getUsers()) {
                            if (!currentAccessRightUser.getUserName().equals(newUserName)) continue;
                            exists = true;
                        }
                        if (exists) continue;
                        AccessRightUserVO accessRightUserVO = new AccessRightUserVO();
                        accessRightUserVO.setUserName(newUserName);
                        AccessRightUser newAccessRightUser = AccessRightController.getController().createAccessRightUser(db, accessRightUserVO, accessRight);
                        accessRight.getUsers().add(newAccessRightUser);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
    }

    private void updateAccessRightsRole(String roleName, String newRoleName) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    List accessRightRoleList = AccessRightController.getController().getAccessRightRoleList(roleName, db, false);
                    for (AccessRightRole accessRightRole : accessRightRoleList) {
                        AccessRight accessRight = accessRightRole.getAccessRight();
                        if (accessRight == null) continue;
                        boolean exists = false;
                        for (AccessRightRole currentAccessRightRole : accessRight.getRoles()) {
                            if (!currentAccessRightRole.getRoleName().equals(newRoleName)) continue;
                            exists = true;
                        }
                        if (exists) continue;
                        AccessRightRoleVO accessRightRoleVO = new AccessRightRoleVO();
                        accessRightRoleVO.setRoleName(newRoleName);
                        AccessRightRole newAccessRightRole = AccessRightController.getController().createAccessRightRole(db, accessRightRoleVO, accessRight);
                        accessRight.getRoles().add(newAccessRightRole);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
    }

    private void updateAccessRightsGroup(String groupName, String newGroupName) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        db.begin();
        try {
            try {
                try {
                    List accessRightGroupList = AccessRightController.getController().getAccessRightGroupList(groupName, db);
                    for (AccessRightGroup accessRightGroup : accessRightGroupList) {
                        AccessRight accessRight = accessRightGroup.getAccessRight();
                        boolean exists = false;
                        for (AccessRightGroup currentAccessRightGroup : accessRight.getGroups()) {
                            if (!currentAccessRightGroup.getGroupName().equals(newGroupName)) continue;
                            exists = true;
                        }
                        if (exists) continue;
                        AccessRightGroupVO accessRightGroupVO = new AccessRightGroupVO();
                        accessRightGroupVO.setGroupName(newGroupName);
                        AccessRightGroup newAccessRightGroup = AccessRightController.getController().createAccessRightGroup(db, accessRightGroupVO, accessRight);
                        accessRight.getGroups().add(newAccessRightGroup);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                db.rollback();
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            db.close();
        }
    }

    public List getInvalidGroups() {
        return this.invalidGroups;
    }

    public List getInvalidRoles() {
        return this.invalidRoles;
    }

    public List getInvalidUsers() {
        return this.invalidUsers;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNewGroupName() {
        return this.newGroupName;
    }

    public void setNewGroupName(String newGroupName) {
        this.newGroupName = newGroupName;
    }

    public String getNewRoleName() {
        return this.newRoleName;
    }

    public void setNewRoleName(String newRoleName) {
        this.newRoleName = newRoleName;
    }

    public String getNewUserName() {
        return this.newUserName;
    }

    public void setNewUserName(String newUserName) {
        this.newUserName = newUserName;
    }

    public List getGroups() {
        return this.groups;
    }

    public List getRoles() {
        return this.roles;
    }

    public List getUsers() {
        return this.users;
    }

    public List getAccessRights() {
        return this.accessRights;
    }
}

