/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.databeans;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;

public class ComponentPropertyDefinition {
    public static final String BINDING = "binding";
    public static final String TEXTFIELD = "textfield";
    public static final String TEXTFAREA = "textarea";
    public static final String SELECTFIELD = "select";
    public static final String CHECKBOXFIELD = "checkbox";
    private String name;
    private String displayName;
    private String type;
    private String entity;
    private Boolean multiple;
    private Boolean assetBinding;
    private Boolean isPuffContentForPage;
    private String allowedContentTypeNames;
    private String description;
    private String defaultValue = "";
    private String dataProvider = "";
    private String dataProviderParameters = "";
    private Boolean WYSIWYGEnabled = new Boolean(false);
    private String WYSIWYGToolbar = "";
    private Boolean autoCreateContent = new Boolean(false);
    private String autoCreateContentMethod = "";
    private String autoCreateContentPath = "";
    private String customMarkup = "";
    private List options = new ArrayList();

    public ComponentPropertyDefinition(String name, String displayName, String type, String entity, Boolean multiple, Boolean assetBinding, Boolean isPuffContentForPage, String allowedContentTypeNames, String description, String defaultValue, Boolean WYSIWYGEnabled, String WYSIWYGToolbar, String dataProvider, String dataProviderParameters, Boolean autoCreateContent, String autoCreateContentMethod, String autoCreateContentPath, String customMarkup) {
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.entity = entity;
        this.multiple = multiple;
        this.assetBinding = assetBinding;
        this.isPuffContentForPage = isPuffContentForPage;
        this.allowedContentTypeNames = allowedContentTypeNames;
        this.description = description;
        this.defaultValue = defaultValue;
        this.WYSIWYGEnabled = WYSIWYGEnabled;
        this.WYSIWYGToolbar = WYSIWYGToolbar;
        this.dataProvider = dataProvider;
        this.dataProviderParameters = dataProviderParameters;
        this.autoCreateContent = autoCreateContent;
        this.autoCreateContentMethod = autoCreateContentMethod;
        this.autoCreateContentPath = autoCreateContentPath;
        this.customMarkup = customMarkup;
    }

    public String getEntity() {
        return this.entity;
    }

    public Boolean getMultiple() {
        return this.multiple;
    }

    public Boolean getAssetBinding() {
        return this.assetBinding;
    }

    public Boolean getIsPuffContentForPage() {
        return this.isPuffContentForPage;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.equals("")) {
            return this.name;
        }
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getAllowedContentTypeNames() {
        return this.allowedContentTypeNames;
    }

    public String getDescription() {
        return this.description;
    }

    public List getOptions() {
        return this.options;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getWYSIWYGEnabled() {
        return this.WYSIWYGEnabled;
    }

    public String getWYSIWYGToolbar() {
        return this.WYSIWYGToolbar;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public String getDataProviderParameters() {
        return this.dataProviderParameters;
    }

    public Boolean getAutoCreateContent() {
        return this.autoCreateContent;
    }

    public String getAutoCreateContentMethod() {
        return this.autoCreateContentMethod;
    }

    public String getAutoCreateContentPath() {
        return this.autoCreateContentPath;
    }

    public String getCustomMarkup() {
        return this.customMarkup;
    }

    public String getEncodedCustomMarkup() {
        VisualFormatter vf = new VisualFormatter();
        return vf.escapeExtendedHTML(this.customMarkup);
    }
}

