/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.wizards.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardAbstractAction;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardInfoBean;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateContentWizardInputContentVersionsAction
extends CreateContentWizardAbstractAction {
    private ContentTypeDefinitionVO contentTypeDefinitionVO = null;
    private List contentTypeAttributes = null;
    private String returnAddress = null;
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
    private String versionValue = null;
    private Integer currentEditorId = null;
    private Integer languageId = null;
    private ContentVersionVO contentVersionVO = new ContentVersionVO();
    private Collection digitalAssets = new ArrayList();

    public String doInput() throws Exception {
        CreateContentWizardInfoBean createContentWizardInfoBean = this.getCreateContentWizardInfoBean();
        Integer contentTypeDefinitionId = createContentWizardInfoBean.getContentTypeDefinitionId();
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentTypeDefinitionId);
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().validateAndUpdateContentType(this.contentTypeDefinitionVO);
        List assetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
        if (this.languageId == null) {
            this.languageId = createContentWizardInfoBean.getLanguageId();
            if (this.languageId == null) {
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(createContentWizardInfoBean.getRepositoryId());
                this.languageId = masterLanguageVO.getLanguageId();
            }
        }
        if (this.contentVersionVO != null && this.contentVersionVO.getContentVersionId() != null) {
            this.digitalAssets = DigitalAssetController.getDigitalAssetVOList(this.contentVersionVO.getId());
        }
        this.contentTypeAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
        String wysiwygEditor = CmsPropertyHandler.getWysiwygEditor();
        if (wysiwygEditor == null || wysiwygEditor.equalsIgnoreCase("") || wysiwygEditor.equalsIgnoreCase("HTMLArea")) {
            return "inputContentVersions";
        }
        return "inputContentVersionsForFCKEditor";
    }

    public String doExecute() throws Exception {
        CreateContentWizardInfoBean createContentWizardInfoBean = this.getCreateContentWizardInfoBean();
        this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
        ContentVersionController.getContentVersionController().update(this.contentVersionVO.getId(), this.contentVersionVO, this.getInfoGluePrincipal());
        return "success";
    }

    public List getContentTypeAttributes() {
        return this.contentTypeAttributes;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }

    public Integer getCurrentEditorId() {
        return this.currentEditorId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public Integer getContentId() {
        return this.getCreateContentWizardInfoBean().getContentVO().getId();
    }

    public void setCurrentEditorId(Integer currentEditorId) {
        this.currentEditorId = currentEditorId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
        this.contentVersionVO.setLanguageId(languageId);
    }

    public void setVersionValue(String versionValue) {
        this.contentVersionVO.setVersionValue(versionValue);
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionVO.setContentVersionId(contentVersionId);
    }

    public Integer getContentVersionId() {
        return this.contentVersionVO.getContentVersionId();
    }

    public Collection getDigitalAssets() {
        return this.digitalAssets;
    }
}

