/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.wizards.actions;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateContentWizardInputContentAction
extends InfoGlueAbstractAction {
    private List contentTypeDefinitionVOList = new ArrayList();
    private String returnAddress;
    private ContentVO contentVO;
    private Integer contentTypeDefinitionId;
    private ConstraintExceptionBuffer ceb;
    private String[] allowedContentTypeIds = null;

    public CreateContentWizardInputContentAction() {
        this(new ContentVO());
    }

    public CreateContentWizardInputContentAction(ContentVO contentVO) {
        this.contentVO = contentVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    private void initialiaze() throws Exception {
        if (this.allowedContentTypeIds == null) {
            this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        } else {
            int i = 0;
            while (i < this.allowedContentTypeIds.length) {
                String allowedContentTypeDefinitionIdString = this.allowedContentTypeIds[i];
                this.contentTypeDefinitionVOList.add(ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(new Integer(allowedContentTypeDefinitionIdString)));
                ++i;
            }
        }
    }

    public String doInput() throws Exception {
        this.initialiaze();
        return "input";
    }

    public String doExecute() throws Exception {
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.ceb = this.contentVO.validate();
        if (!this.ceb.isEmpty()) {
            this.initialiaze();
        }
        this.ceb.throwIfNotEmpty();
        return "success";
    }

    public List getContentTypeDefinitions() throws Exception {
        return this.contentTypeDefinitionVOList;
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public void setName(String name) {
        this.contentVO.setName(name);
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public void setPublishDateTime(String publishDateTime) {
        this.contentVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public void setExpireDateTime(String expireDateTime) {
        this.contentVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public long getPublishDateTimeAsLong() {
        return this.contentVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.contentVO.getExpireDateTime().getTime();
    }

    public Boolean getIsBranch() {
        return this.contentVO.getIsBranch();
    }

    public void setIsBranch(Boolean isBranch) {
        this.contentVO.setIsBranch(isBranch);
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String string) {
        this.returnAddress = string;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }
}

