/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.wizards.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardAbstractAction;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardInfoBean;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import webwork.action.ActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class CreateContentWizardInputAssetsAction
extends CreateContentWizardAbstractAction {
    private static final Logger logger = Logger.getLogger((String)CreateContentWizardInputAssetsAction.class.getName());
    private String mandatoryAssetKey = null;
    private String mandatoryAssetMaximumSize = null;
    private String digitalAssetKey = "";
    private Integer uploadedFilesCounter = new Integer(0);
    private ContentTypeDefinitionVO contentTypeDefinitionVO = null;
    private Integer languageId = null;
    private Integer contentVersionId = null;
    private String inputMoreAssets = null;

    public String doInput() throws Exception {
        CreateContentWizardInfoBean createContentWizardInfoBean = this.getCreateContentWizardInfoBean();
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(createContentWizardInfoBean.getContentTypeDefinitionId());
        List assetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
        if (this.languageId == null) {
            this.languageId = createContentWizardInfoBean.getLanguageId();
            if (this.languageId == null) {
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(createContentWizardInfoBean.getRepositoryId());
                this.languageId = masterLanguageVO.getLanguageId();
            }
        }
        if (this.contentVersionId == null) {
            ContentVersionVO newContentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(createContentWizardInfoBean.getContentVO().getId(), this.languageId);
            this.contentVersionId = newContentVersion.getId();
        }
        boolean hasMandatoryAssets = false;
        boolean missingAsset = false;
        for (AssetKeyDefinition assetKeyDefinition : assetKeys) {
            if (!assetKeyDefinition.getIsMandatory().booleanValue()) continue;
            hasMandatoryAssets = true;
            DigitalAssetController.getController();
            DigitalAssetVO asset = DigitalAssetController.getDigitalAssetVO(createContentWizardInfoBean.getContentVO().getId(), this.languageId, assetKeyDefinition.getAssetKey(), false);
            if (asset != null) continue;
            this.mandatoryAssetKey = assetKeyDefinition.getAssetKey();
            this.mandatoryAssetMaximumSize = "" + assetKeyDefinition.getMaximumSize();
            missingAsset = true;
            break;
        }
        if (!hasMandatoryAssets && !this.inputMoreAssets.equalsIgnoreCase("false")) {
            this.inputMoreAssets = "true";
        }
        if (missingAsset) {
            this.inputMoreAssets = "false";
            return "input";
        }
        if (this.inputMoreAssets != null && this.inputMoreAssets.equalsIgnoreCase("true")) {
            return "input";
        }
        return "success";
    }

    public String doExecute() throws Exception {
        block21: {
            InputStream is = null;
            File renamedFile = null;
            DigitalAssetVO digitalAssetVO = null;
            try {
                try {
                    ActionContext.getContext();
                    MultiPartRequestWrapper mpr = ActionContext.getMultiPartRequest();
                    if (mpr != null) {
                        String toEncoding;
                        String fromEncoding = CmsPropertyHandler.getUploadFromEncoding();
                        if (fromEncoding == null) {
                            fromEncoding = "iso-8859-1";
                        }
                        if ((toEncoding = CmsPropertyHandler.getUploadToEncoding()) == null) {
                            toEncoding = "utf-8";
                        }
                        this.digitalAssetKey = new String(this.digitalAssetKey.getBytes(fromEncoding), toEncoding);
                        Enumeration names = mpr.getFileNames();
                        while (names.hasMoreElements()) {
                            String name = (String)names.nextElement();
                            String contentType = mpr.getContentType(name);
                            String fileSystemName = mpr.getFilesystemName(name);
                            File file = mpr.getFile(name);
                            String fileName = String.valueOf(this.digitalAssetKey) + "_" + System.currentTimeMillis() + "_" + fileSystemName;
                            String tempFileName = "tmp_" + fileName;
                            tempFileName = new VisualFormatter().replaceNonAscii(fileName, '_');
                            String filePath = CmsPropertyHandler.getDigitalAssetPath();
                            fileSystemName = String.valueOf(filePath) + File.separator + tempFileName;
                            renamedFile = new File(fileSystemName);
                            if (renamedFile == null || file == null) continue;
                            boolean isRenamed = file.renameTo(renamedFile);
                            DigitalAssetVO newAsset = new DigitalAssetVO();
                            newAsset.setAssetContentType(contentType);
                            newAsset.setAssetKey(this.digitalAssetKey);
                            newAsset.setAssetFileName(fileName);
                            newAsset.setAssetFilePath(filePath);
                            newAsset.setAssetFileSize(new Integer(new Long(renamedFile.length()).intValue()));
                            is = new FileInputStream(renamedFile);
                            digitalAssetVO = DigitalAssetController.create(newAsset, is, this.contentVersionId, this.getInfoGluePrincipal());
                            this.uploadedFilesCounter = new Integer(this.uploadedFilesCounter + 1);
                        }
                    } else {
                        logger.error((Object)"File upload failed for some reason.");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred when we tried to upload a new asset:" + e.getMessage()), (Throwable)e);
                    try {
                        is.close();
                        if (CmsPropertyHandler.getEnableDiskAssets().equals("true")) {
                            String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                            String assetFileName = digitalAssetVO.getAssetFilePath() + File.separator + folderName + File.separator + digitalAssetVO.getId() + "_" + digitalAssetVO.getAssetFileName();
                            File assetFile = new File(assetFileName);
                            renamedFile.renameTo(assetFile);
                            break block21;
                        }
                        renamedFile.delete();
                    }
                    catch (Exception folderName) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    if (CmsPropertyHandler.getEnableDiskAssets().equals("true")) {
                        String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                        String assetFileName = digitalAssetVO.getAssetFilePath() + File.separator + folderName + File.separator + digitalAssetVO.getId() + "_" + digitalAssetVO.getAssetFileName();
                        File assetFile = new File(assetFileName);
                        renamedFile.renameTo(assetFile);
                    } else {
                        renamedFile.delete();
                    }
                }
                catch (Exception folderName) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
                if (CmsPropertyHandler.getEnableDiskAssets().equals("true")) {
                    String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                    String assetFileName = digitalAssetVO.getAssetFilePath() + File.separator + folderName + File.separator + digitalAssetVO.getId() + "_" + digitalAssetVO.getAssetFileName();
                    File assetFile = new File(assetFileName);
                    renamedFile.renameTo(assetFile);
                } else {
                    renamedFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.doInput();
    }

    public String doFinish() throws Exception {
        return "success";
    }

    public void setDigitalAssetKey(String digitalAssetKey) {
        this.digitalAssetKey = digitalAssetKey;
    }

    public void setUploadedFilesCounter(Integer uploadedFilesCounter) {
        this.uploadedFilesCounter = uploadedFilesCounter;
    }

    public Integer getUploadedFilesCounter() {
        return this.uploadedFilesCounter;
    }

    public List getDefinedAssetKeys() {
        return ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public String getMandatoryAssetKey() {
        return this.mandatoryAssetKey;
    }

    public void setMandatoryAssetKey(String string) {
        this.mandatoryAssetKey = string;
    }

    public String getMandatoryAssetMaximumSize() {
        return this.mandatoryAssetMaximumSize;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer integer) {
        this.languageId = integer;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public String getInputMoreAssets() {
        return this.inputMoreAssets;
    }

    public void setInputMoreAssets(String inputMoreAssets) {
        this.inputMoreAssets = inputMoreAssets;
    }
}

