/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.wizards.actions;

import java.util.Iterator;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardAbstractAction;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardInfoBean;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateContentWizardFinishAction
extends CreateContentWizardAbstractAction {
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
    private String returnAddress = "CreateContentWizardFinish.action";
    private String refreshAddress = null;
    private Integer contentId = null;
    private Integer contentVersionId = null;
    private String versionDone = null;
    private String mandatoryAssetKey = null;
    private String mandatoryAssetMaximumSize = null;
    private String inputMoreAssets = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doExecute() throws Exception {
        try {
            CreateContentWizardInfoBean createContentWizardInfoBean;
            block11: {
                AssetKeyDefinition assetKeyDefinition;
                createContentWizardInfoBean = this.getCreateContentWizardInfoBean();
                if (createContentWizardInfoBean.getParentContentId() == null) {
                    return "stateLocation";
                }
                createContentWizardInfoBean.getContent().setCreator(this.getInfoGluePrincipal().getName());
                this.ceb = createContentWizardInfoBean.getContent().getValueObject().validate();
                if (!this.ceb.isEmpty()) {
                    return "inputContent";
                }
                Integer repositoryId = createContentWizardInfoBean.getRepositoryId();
                Integer languageId = createContentWizardInfoBean.getLanguageId();
                if (languageId == null) {
                    languageId = LanguageController.getController().getMasterLanguage(repositoryId).getId();
                }
                if (createContentWizardInfoBean.getContentVersions().size() == 0) {
                    String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes></attributes></article>";
                    ContentVersionVO initialContentVersionVO = new ContentVersionVO();
                    initialContentVersionVO.setVersionComment("Preversion");
                    initialContentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                    initialContentVersionVO.setVersionValue(versionValue);
                    createContentWizardInfoBean.getContentVersions().put(languageId, initialContentVersionVO);
                    ContentVO contentVO = ContentControllerProxy.getController().acCreate(this.getInfoGluePrincipal(), createContentWizardInfoBean);
                    this.contentId = contentVO.getContentId();
                    createContentWizardInfoBean.setContentVO(contentVO);
                    ContentVersionVO newContentVersion = (ContentVersionVO)createContentWizardInfoBean.getContentVersions().get(languageId);
                    this.contentVersionId = newContentVersion.getId();
                }
                ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(createContentWizardInfoBean.getContentTypeDefinitionId());
                List assetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(contentTypeDefinitionVO.getSchemaValue());
                boolean hasMandatoryAssets = false;
                Iterator assetKeysIterator = assetKeys.iterator();
                while (true) {
                    if (!assetKeysIterator.hasNext()) {
                        if (!(this.inputMoreAssets != null || this.versionDone != null && this.versionDone.equalsIgnoreCase("true"))) {
                            this.inputMoreAssets = "true";
                        }
                        if (this.inputMoreAssets != null && this.inputMoreAssets.equalsIgnoreCase("true")) {
                            return "inputAssets";
                        }
                        break block11;
                    }
                    assetKeyDefinition = (AssetKeyDefinition)assetKeysIterator.next();
                    if (!assetKeyDefinition.getIsMandatory().booleanValue()) continue;
                    hasMandatoryAssets = true;
                    DigitalAssetController.getController();
                    DigitalAssetVO asset = DigitalAssetController.getDigitalAssetVO(createContentWizardInfoBean.getContentVO().getId(), languageId, assetKeyDefinition.getAssetKey(), false);
                    if (asset == null) break;
                }
                this.mandatoryAssetKey = assetKeyDefinition.getAssetKey();
                this.mandatoryAssetMaximumSize = "" + assetKeyDefinition.getMaximumSize();
                return "inputAssets";
            }
            if (this.versionDone != null && !this.versionDone.equals("false")) {
                String returnAddress = createContentWizardInfoBean.getReturnAddress();
                returnAddress = returnAddress.replaceAll("#entityId", createContentWizardInfoBean.getContentVO().getId().toString());
                returnAddress = returnAddress.replaceAll("#path", createContentWizardInfoBean.getContentVO().getName());
                this.invalidateCreateContentWizardInfoBean();
                this.getResponse().sendRedirect(returnAddress);
                return "none";
            }
            String wysiwygEditor = CmsPropertyHandler.getWysiwygEditor();
            if (wysiwygEditor == null) return "inputContentVersions";
            if (wysiwygEditor.equalsIgnoreCase("")) return "inputContentVersions";
            if (!wysiwygEditor.equalsIgnoreCase("HTMLArea")) return "inputContentVersionsForFCKEditor";
            return "inputContentVersions";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "none";
    }

    public String doCancel() throws Exception {
        try {
            CreateContentWizardInfoBean createContentWizardInfoBean = this.getCreateContentWizardInfoBean();
            String cancelAddress = createContentWizardInfoBean.getCancelAddress();
            if (createContentWizardInfoBean.getContentVO() != null) {
                ContentControllerProxy.getController().acDelete(this.getInfoGluePrincipal(), createContentWizardInfoBean.getContentVO());
            }
            this.invalidateCreateContentWizardInfoBean();
            this.getResponse().sendRedirect(cancelAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "none";
    }

    public void setParentContentId(Integer parentContentId) {
        this.getCreateContentWizardInfoBean().setParentContentId(parentContentId);
    }

    public Integer getParentContentId() {
        return this.getCreateContentWizardInfoBean().getParentContentId();
    }

    public void setRepositoryId(Integer repositoryId) {
        this.getCreateContentWizardInfoBean().setRepositoryId(repositoryId);
    }

    public Integer getRepositoryId() {
        return this.getCreateContentWizardInfoBean().getRepositoryId();
    }

    public void setLanguageId(Integer languageId) {
        this.getCreateContentWizardInfoBean().setLanguageId(languageId);
    }

    public Integer getLanguageId() {
        return this.getCreateContentWizardInfoBean().getLanguageId();
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.getCreateContentWizardInfoBean().setContentTypeDefinitionId(contentTypeDefinitionId);
    }

    public Integer getContentTypeDefinitionId() {
        return this.getCreateContentWizardInfoBean().getContentTypeDefinitionId();
    }

    public String getName() {
        return this.getCreateContentWizardInfoBean().getContent().getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.getCreateContentWizardInfoBean().getContent().getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.getCreateContentWizardInfoBean().getContent().getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public Boolean getIsBranch() {
        return this.getCreateContentWizardInfoBean().getContent().getIsBranch();
    }

    public void setName(String name) {
        this.getCreateContentWizardInfoBean().getContent().setName(name);
    }

    public void setPublishDateTime(String publishDateTime) {
        this.getCreateContentWizardInfoBean().getContent().setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        this.getCreateContentWizardInfoBean().getContent().setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.getCreateContentWizardInfoBean().getContent().setIsBranch(isBranch);
    }

    public ContentVO getContentVO() {
        return this.getCreateContentWizardInfoBean().getContent().getValueObject();
    }

    public void setContentVO(ContentVO contentVO) {
        this.getCreateContentWizardInfoBean().getContent().setValueObject(contentVO);
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setRefreshAddress(String refreshAddress) {
        this.getCreateContentWizardInfoBean().setReturnAddress(refreshAddress);
    }

    public String getRefreshAddress() {
        return this.getCreateContentWizardInfoBean().getReturnAddress();
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public String getVersionDone() {
        return this.versionDone;
    }

    public void setVersionDone(String versionDone) {
        this.versionDone = versionDone;
    }

    public String getInputMoreAssets() {
        return this.inputMoreAssets;
    }

    public void setInputMoreAssets(String inputMoreAssets) {
        this.inputMoreAssets = inputMoreAssets;
    }

    public String getMandatoryAssetKey() {
        return this.mandatoryAssetKey;
    }

    public void setMandatoryAssetKey(String mandatoryAssetKey) {
        this.mandatoryAssetKey = mandatoryAssetKey;
    }

    public String getMandatoryAssetMaximumSize() {
        return this.mandatoryAssetMaximumSize;
    }
}

