/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.wizards.actions;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.contenttool.actions.ViewContentTreeActionInterface;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateContentWizardAction
extends InfoGlueAbstractAction
implements ViewContentTreeActionInterface {
    private static final long serialVersionUID = 1L;
    private Integer contentId;
    private String tree;
    private String hideLeafs;
    private String[] allowedContentTypeDefinitionId;
    private List contentTypeDefinitionVOList = new ArrayList();
    public ContentTypeDefinitionVO contentTypeDefinitionVO;
    public List availableLanguages = null;
    private Integer languageId;
    private Integer contentVersionId;
    private Integer currentEditorId;
    private String attributeName = "";
    private String textAreaId = "";
    private ContentVersionVO contentVersionVO;
    public List attributes = null;
    private Integer parentContentId;
    private Integer contentTypeDefinitionId;
    private Integer repositoryId;
    private ConstraintExceptionBuffer ceb;
    private ContentVO contentVO;
    private ContentVO newContentVO;

    protected void initialize(Integer contentVersionId, Integer contentId, Integer languageId) throws Exception {
        this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), contentId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(contentId);
        this.availableLanguages = ContentController.getContentController().getRepositoryLanguages(contentId);
        this.languageId = ((LanguageVO)this.availableLanguages.get(0)).getLanguageId();
        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().validateAndUpdateContentType(this.contentTypeDefinitionVO);
        this.attributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public String doInput() throws Exception {
        if (this.parentContentId == null) {
            return "stateLocation";
        }
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.parentContentId);
        if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.Create", protectedContentId.toString())) {
            ceb.add(new AccessConstraintException("Content.contentId", "1002"));
        }
        ceb.throwIfNotEmpty();
        if (this.allowedContentTypeDefinitionId == null) {
            this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        } else {
            int i = 0;
            while (i < this.allowedContentTypeDefinitionId.length) {
                String allowedContentTypeDefinitionIdString = this.allowedContentTypeDefinitionId[i];
                this.contentTypeDefinitionVOList.add(ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(new Integer(allowedContentTypeDefinitionIdString)));
                ++i;
            }
        }
        return "input";
    }

    public String doCreateContent() throws Exception {
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.ceb = this.contentVO.validate();
        this.ceb.throwIfNotEmpty();
        this.newContentVO = ContentControllerProxy.getController().acCreate(this.getInfoGluePrincipal(), this.parentContentId, this.contentTypeDefinitionId, this.repositoryId, this.contentVO);
        this.initialize(this.contentVersionId, this.newContentVO.getContentId(), this.languageId);
        return "createContentSuccess";
    }

    public String doExecute() throws Exception {
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.ceb = this.contentVO.validate();
        this.ceb.throwIfNotEmpty();
        this.newContentVO = ContentControllerProxy.getController().acCreate(this.getInfoGluePrincipal(), this.parentContentId, this.contentTypeDefinitionId, this.repositoryId, this.contentVO);
        return "success";
    }

    public Integer getTopRepositoryId() throws ConstraintException, SystemException, Bug {
        List repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        Integer topRepositoryId = null;
        if (this.repositoryId != null) {
            topRepositoryId = this.repositoryId;
        }
        if (repositories.size() > 0) {
            topRepositoryId = ((RepositoryVO)repositories.get(0)).getRepositoryId();
        }
        return topRepositoryId;
    }

    public CreateContentWizardAction() {
        this(new ContentVO());
    }

    public CreateContentWizardAction(ContentVO contentVO) {
        this.contentVO = contentVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setHideLeafs(String hideLeafs) {
        this.hideLeafs = hideLeafs;
    }

    public String getHideLeafs() {
        return this.hideLeafs;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        try {
            if (this.repositoryId == null) {
                this.repositoryId = (Integer)this.getHttpSession().getAttribute("repositoryId");
                if (this.repositoryId == null) {
                    this.repositoryId = this.getTopRepositoryId();
                    this.getHttpSession().setAttribute("repositoryId", (Object)this.repositoryId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.repositoryId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public long getPublishDateTimeAsLong() {
        return this.contentVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.contentVO.getExpireDateTime().getTime();
    }

    public Boolean getIsBranch() {
        return this.contentVO.getIsBranch();
    }

    public void setName(String name) {
        this.contentVO.setName(name);
    }

    public void setPublishDateTime(String publishDateTime) {
        this.contentVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        this.contentVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.contentVO.setIsBranch(isBranch);
    }

    public Integer getNewContentId() {
        return this.newContentVO.getContentId();
    }

    public List getContentTypeDefinitions() throws Exception {
        return ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
    }

    public String[] getAllowedContentTypeDefinitionId() {
        return this.allowedContentTypeDefinitionId;
    }

    public void setAllowedContentTypeDefinitionId(String[] strings) {
        this.allowedContentTypeDefinitionId = strings;
    }

    public Integer getContentVersionId() {
        return this.contentVersionVO.getContentVersionId();
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionVO.setContentVersionId(contentVersionId);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }

    public ContentVersionVO getContentVersionVO() {
        return this.contentVersionVO;
    }

    public ContentVO getContentVO() {
        return this.contentVO;
    }

    public Integer getCurrentEditorId() {
        return this.currentEditorId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public ContentVO getNewContentVO() {
        return this.newContentVO;
    }

    public String getTextAreaId() {
        return this.textAreaId;
    }

    public void setAttributes(List list) {
        this.attributes = list;
    }

    public List getContentTypeAttributes() {
        return this.attributes;
    }

    public void setAvailableLanguages(List list) {
        this.availableLanguages = list;
    }

    public void setContentTypeDefinitionVO(ContentTypeDefinitionVO definitionVO) {
        this.contentTypeDefinitionVO = definitionVO;
    }

    public void setContentVersionVO(ContentVersionVO versionVO) {
        this.contentVersionVO = versionVO;
    }

    public void setContentVO(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    public void setCurrentEditorId(Integer integer) {
        this.currentEditorId = integer;
    }

    public void setLanguageId(Integer integer) {
        this.languageId = integer;
    }

    public void setNewContentVO(ContentVO contentVO) {
        this.newContentVO = contentVO;
    }

    public void setTextAreaId(String string) {
        this.textAreaId = string;
    }
}

