/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.dom.DOMBuilder;

public abstract class ViewRelationEditorAction
extends InfoGlueAbstractAction {
    protected Integer entityId = null;
    protected String entityName = null;
    protected String attributeName = null;
    protected String updateAction = null;
    protected Integer repositoryId = null;
    protected ConstraintExceptionBuffer ceb = null;
    protected String qualifyerXML = null;
    protected String relationXML = null;
    protected String tree = null;
    protected List repositories = null;
    protected String path = null;
    protected List qualifyers = null;
    protected String currentAction = null;
    protected String changeRepositoryAction = null;
    protected String currentEntity = null;
    protected String currentEntityIdentifyer = null;

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setQualifyerXML(String qualifyerXML) {
        this.qualifyerXML = qualifyerXML;
    }

    public String getQualifyerXML() {
        return this.qualifyerXML;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public List getQualifyers() {
        return this.qualifyers;
    }

    public String getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(String currentEntity) {
        this.currentEntity = currentEntity;
    }

    public String getCurrentEntityIdentifyer() {
        return this.currentEntityIdentifyer;
    }

    public void setCurrentEntityIdentifyer(String currentEntityIdentifyer) {
        this.currentEntityIdentifyer = currentEntityIdentifyer;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public String getChangeRepositoryAction() {
        return this.changeRepositoryAction;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public abstract String getQualifyerPath(String var1);

    protected void initialize() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        if (this.repositoryId == null) {
            this.repositoryId = (Integer)this.getHttpSession().getAttribute("repositoryId");
            if (this.repositoryId == null) {
                this.repositoryId = RepositoryController.getController().getFirstRepositoryVO().getRepositoryId();
            }
        }
        this.relationXML = this.getXML();
        boolean isFormDefinitionValid = true;
        try {
            if (this.relationXML != null && this.relationXML.length() != 0) {
                Document document = new DOMBuilder().getDocument(this.relationXML);
                this.qualifyers = this.parseQualifyersFromXML(this.relationXML);
            } else {
                isFormDefinitionValid = false;
            }
        }
        catch (Exception e) {
            isFormDefinitionValid = false;
        }
    }

    public String doExecute() throws Exception {
        this.initialize();
        return "success";
    }

    public String doChangeRepository() throws Exception {
        this.initialize();
        return "success";
    }

    public String doUpdateQualifyer() throws Exception {
        this.updateAttributeValue();
        this.initialize();
        return "success";
    }

    public String doUpdateQualifyerInEntityProperties() throws Exception {
        if (this.entityName.equalsIgnoreCase(UserProperties.class.getName())) {
            UserPropertiesController.getController().updateAttributeValue(this.getEntityId(), this.getAttributeName(), this.qualifyerXML);
        } else if (this.entityName.equalsIgnoreCase(RoleProperties.class.getName())) {
            RolePropertiesController.getController().updateAttributeValue(this.getEntityId(), this.getAttributeName(), this.qualifyerXML);
        } else if (this.entityName.equalsIgnoreCase(GroupProperties.class.getName())) {
            GroupPropertiesController.getController().updateAttributeValue(this.getEntityId(), this.getAttributeName(), this.qualifyerXML);
        }
        this.initialize();
        return "success";
    }

    private List parseQualifyersFromXML(String qualifyerXML) {
        ArrayList<QualifyerVO> qualifyers = new ArrayList<QualifyerVO>();
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (Element child : children) {
                String id = child.getStringValue();
                QualifyerVO qualifyerVO = new QualifyerVO();
                qualifyerVO.setName(this.getCurrentEntityIdentifyer());
                qualifyerVO.setValue(id);
                qualifyerVO.setPath(this.getQualifyerPath(id));
                qualifyers.add(qualifyerVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qualifyers;
    }

    public String getXML() {
        try {
            if (this.entityName.equalsIgnoreCase(UserProperties.class.getName())) {
                return UserPropertiesController.getController().getAttributeValue(this.getEntityId(), this.getAttributeName(), false);
            }
            if (this.entityName.equalsIgnoreCase(RoleProperties.class.getName())) {
                return RolePropertiesController.getController().getAttributeValue(this.getEntityId(), this.getAttributeName(), false);
            }
            if (this.entityName.equalsIgnoreCase(GroupProperties.class.getName())) {
                return GroupPropertiesController.getController().getAttributeValue(this.getEntityId(), this.getAttributeName(), false);
            }
            return ContentVersionController.getContentVersionController().getAttributeValue(this.getEntityId(), this.getAttributeName(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void updateAttributeValue() throws Exception {
        ContentVersionController.getContentVersionController().updateAttributeValue(this.getEntityId(), this.getAttributeName(), this.qualifyerXML, this.getInfoGluePrincipal());
    }
}

