/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class ViewListContentVersionAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = -1767277488570719994L;
    private List contentVersionVOList = new ArrayList();
    private List siteNodeVersionVOList = new ArrayList();
    private Integer contentId;
    private Integer repositoryId;
    private String returnAddress = null;

    protected String doExecute() throws Exception {
        if (this.contentId != null) {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
            this.repositoryId = contentVO.getRepositoryId();
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.contentId);
            if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.SubmitToPublish", protectedContentId.toString())) {
                ceb.add(new AccessConstraintException("Content.contentId", "1005"));
            }
            ceb.throwIfNotEmpty();
            ContentVersionController.getContentVersionController().getContentAndAffectedItemsRecursive(this.contentId, ContentVersionVO.WORKING_STATE, this.siteNodeVersionVOList, this.contentVersionVOList, true, true);
            HashSet contentVersionVOListSet = new HashSet();
            contentVersionVOListSet.addAll(this.contentVersionVOList);
            this.contentVersionVOList.clear();
            this.contentVersionVOList.addAll(contentVersionVOListSet);
            Collections.sort(this.contentVersionVOList, Collections.reverseOrder(new ReflectionComparator("modifiedDateTime")));
            HashSet siteNodeVersionVOListSet = new HashSet();
            siteNodeVersionVOListSet.addAll(this.siteNodeVersionVOList);
            this.siteNodeVersionVOList.clear();
            this.siteNodeVersionVOList.addAll(siteNodeVersionVOListSet);
            Collections.sort(this.siteNodeVersionVOList, Collections.reverseOrder(new ReflectionComparator("modifiedDateTime")));
        }
        return "success";
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer integer) {
        this.contentId = integer;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public List getContentVersionVOList() {
        return this.contentVersionVOList;
    }

    public List getSiteNodeVersionVOList() {
        return this.siteNodeVersionVOList;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }
}

