/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.GroupPropertiesVO;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.RolePropertiesVO;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.entities.management.UserPropertiesVO;

public class ViewDigitalAssetAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewDigitalAssetAction.class.getName());
    private static final long serialVersionUID = 1L;
    private List availableLanguages = null;
    private String entity;
    private Integer entityId;
    private Integer contentVersionId = null;
    private Integer digitalAssetId = null;
    private Integer uploadedFilesCounter = new Integer(0);
    private UserPropertiesVO userPropertiesVO;
    private UserPropertiesVO rolePropertiesVO;
    private ContentVersionVO contentVersionVO;
    protected ContentTypeDefinitionVO contentTypeDefinitionVO;
    private DigitalAssetVO digitalAssetVO;

    public ViewDigitalAssetAction() {
        this(new ContentVersionVO());
    }

    public ViewDigitalAssetAction(ContentVersionVO contentVersionVO) {
        logger.info((Object)"Construction ViewDigitalAssetAction");
        this.contentVersionVO = contentVersionVO;
    }

    public String doExecute() throws Exception {
        if (this.contentVersionId != null) {
            this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
            this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        } else if (this.entity.equalsIgnoreCase(UserProperties.class.getName())) {
            UserPropertiesVO userPropertiesVO = UserPropertiesController.getController().getUserPropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(userPropertiesVO.getContentTypeDefinitionId());
        } else if (this.entity.equalsIgnoreCase(RoleProperties.class.getName())) {
            RolePropertiesVO rolePropertiesVO = RolePropertiesController.getController().getRolePropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(rolePropertiesVO.getContentTypeDefinitionId());
        } else if (this.entity.equalsIgnoreCase(GroupProperties.class.getName())) {
            GroupPropertiesVO groupPropertiesVO = GroupPropertiesController.getController().getGroupPropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(groupPropertiesVO.getContentTypeDefinitionId());
        }
        return "success";
    }

    public String doMultiple() throws Exception {
        this.doExecute();
        return "successMultiple";
    }

    public String doUpdate() throws Exception {
        this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
        if (this.contentVersionId != null) {
            this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
            this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        } else if (this.entity.equalsIgnoreCase(UserProperties.class.getName())) {
            UserPropertiesVO userPropertiesVO = UserPropertiesController.getController().getUserPropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(userPropertiesVO.getContentTypeDefinitionId());
        } else if (this.entity.equalsIgnoreCase(RoleProperties.class.getName())) {
            RolePropertiesVO rolePropertiesVO = RolePropertiesController.getController().getRolePropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(rolePropertiesVO.getContentTypeDefinitionId());
        } else if (this.entity.equalsIgnoreCase(GroupProperties.class.getName())) {
            GroupPropertiesVO groupPropertiesVO = GroupPropertiesController.getController().getGroupPropertiesVOWithId(this.entityId);
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(groupPropertiesVO.getContentTypeDefinitionId());
        }
        return "update";
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public Integer getUploadedFilesCounter() {
        return this.uploadedFilesCounter;
    }

    public List getDefinedAssetKeys() {
        return ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public Integer getDigitalAssetId() {
        return this.digitalAssetId;
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }

    public String getDigitalAssetKey() {
        return this.digitalAssetVO.getAssetKey();
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }
}

