/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ComponentPropertyDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.css.CSSHelper;
import org.infoglue.cms.util.dom.DOMBuilder;

public class ViewContentVersionAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentVersionAction.class.getName());
    private static final long serialVersionUID = 1L;
    private static CategoryController categoryController = CategoryController.getController();
    private static ContentCategoryController contentCategoryController = ContentCategoryController.getController();
    private Integer unrefreshedContentId = new Integer(0);
    private Integer changeTypeId = new Integer(0);
    private Integer newContentId = new Integer(0);
    private Integer digitalAssetId = null;
    public ContentTypeDefinitionVO contentTypeDefinitionVO;
    public List availableLanguages = null;
    private Integer languageId;
    private Integer repositoryId;
    private Integer currentEditorId;
    private String attributeName = "";
    private String textAreaId = "";
    private boolean forceWorkingChange = false;
    private ContentVO contentVO;
    protected ContentVersionVO contentVersionVO;
    protected ContentVersionVO originalLanguageContentVersionVO;
    private LanguageVO currentLanguageVO;
    public List attributes = null;
    private List repositories;
    private Integer siteNodeId;
    private Integer oldContentId = null;
    private String assetKey = null;
    private boolean treatAsLink = false;
    private boolean isAssetBinding = false;
    private Map WYSIWYGProperties = null;
    private String closeOnLoad = "false";
    private String publishOnLoad = "false";
    private boolean concurrentModification = false;
    private long oldModifiedDateTime = -1L;
    private String propertyName;
    private Integer componentId;
    private boolean showSimple = false;
    private String assignedPath;
    private Integer assignedContentId;
    private String assignedAssetKey;
    private String anchor = null;
    private String anchorName = null;
    private boolean showActionButtons = true;
    private boolean showSelectButtonByEachImage = false;
    private boolean translate = false;
    private Integer fromLanguageId;
    private Integer toLanguageId;
    private String returnAddress = "";

    public String getQualifyerPath(String entity, String entityId) {
        StringBuffer sb = new StringBuffer("");
        try {
            if (entity.equalsIgnoreCase("Content")) {
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(entityId));
                sb.insert(0, String.valueOf(contentVO.getName()) + "/");
                while (contentVO.getParentContentId() != null) {
                    contentVO = ContentController.getContentController().getContentVOWithId(contentVO.getParentContentId());
                    sb.insert(0, String.valueOf(contentVO.getName()) + "/");
                }
            } else if (entity.equalsIgnoreCase("SiteNode")) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(new Integer(entityId));
                sb.insert(0, String.valueOf(siteNodeVO.getName()) + "/");
                while (siteNodeVO.getParentSiteNodeId() != null) {
                    siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeVO.getParentSiteNodeId());
                    sb.insert(0, String.valueOf(siteNodeVO.getName()) + "/");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public List getContentRelationQualifyers(String qualifyerXML) {
        logger.info((Object)("Content qualifyerXML:" + qualifyerXML));
        return this.parseQualifyersFromXML(qualifyerXML, "contentId");
    }

    public List getSiteNodeRelationQualifyers(String qualifyerXML) {
        logger.info((Object)("Content qualifyerXML:" + qualifyerXML));
        return this.parseQualifyersFromXML(qualifyerXML, "siteNodeId");
    }

    public List getComponentPropertyDefinitions(String componentPropertiesXML) {
        return ComponentPropertyDefinitionController.getController().parseComponentPropertyDefinitions(componentPropertiesXML);
    }

    private List parseQualifyersFromXML(String qualifyerXML, String currentEntityIdentifyer) {
        ArrayList<QualifyerVO> qualifyers = new ArrayList<QualifyerVO>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return qualifyers;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (Element child : children) {
                String id = child.getStringValue();
                QualifyerVO qualifyerVO = new QualifyerVO();
                qualifyerVO.setName(currentEntityIdentifyer);
                qualifyerVO.setValue(id);
                qualifyerVO.setPath(this.getQualifyerPath(entity, id));
                qualifyers.add(qualifyerVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qualifyers;
    }

    public ViewContentVersionAction() {
        this(new ContentVO(), new ContentVersionVO());
    }

    public ViewContentVersionAction(ContentVO contentVO, ContentVersionVO contentVersionVO) {
        this.contentVO = contentVO;
        this.contentVersionVO = contentVersionVO;
    }

    protected void initialize(Integer contentVersionId, Integer contentId, Integer languageId) throws Exception {
        this.initialize(contentVersionId, contentId, languageId, false, true);
    }

    protected void initialize(Integer contentVersionId, Integer contentId, Integer languageId, boolean fallBackToMasterLanguage, boolean checkPermission) throws ConstraintException, Exception {
        if (contentVersionId != null && contentId == null) {
            this.contentVersionVO = ContentVersionControllerProxy.getController().getACContentVersionVOWithId(this.getInfoGluePrincipal(), contentVersionId);
            contentId = this.contentVersionVO.getContentId();
            languageId = this.contentVersionVO.getLanguageId();
            this.languageId = this.contentVersionVO.getLanguageId();
        }
        this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), contentId);
        if (this.contentVO.getRepositoryId() != null && checkPermission && !this.hasAccessTo("Repository.Read", "" + this.contentVO.getRepositoryId())) {
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            ceb.add(new AccessConstraintException("Content.contentId", "1000"));
            ceb.throwIfNotEmpty();
        }
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(contentId);
        this.availableLanguages = ContentController.getContentController().getRepositoryLanguages(contentId);
        if (contentVersionId == null) {
            this.contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
            if (this.contentVersionVO == null && fallBackToMasterLanguage) {
                Integer usedRepositoryId = this.repositoryId;
                if (this.repositoryId == null && this.contentVO != null) {
                    usedRepositoryId = this.contentVO.getRepositoryId();
                }
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(usedRepositoryId);
                this.contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguageVO.getId());
            }
            if (this.contentVersionVO != null) {
                contentVersionId = this.contentVersionVO.getContentVersionId();
            }
        }
        if (contentVersionId != null) {
            this.contentVersionVO = ContentVersionControllerProxy.getController().getACContentVersionVOWithId(this.getInfoGluePrincipal(), contentVersionId);
        }
        if (this.contentTypeDefinitionVO != null) {
            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().validateAndUpdateContentType(this.contentTypeDefinitionVO);
            this.attributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(this.contentTypeDefinitionVO.getSchemaValue());
        }
        if (this.fromLanguageId != null) {
            this.originalLanguageContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, this.fromLanguageId);
        }
        if (this.toLanguageId != null) {
            this.currentLanguageVO = LanguageController.getController().getLanguageVOWithId(this.toLanguageId);
        } else if (this.languageId != null) {
            this.currentLanguageVO = LanguageController.getController().getLanguageVOWithId(languageId);
        }
    }

    public String doExecute() throws Exception {
        this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId);
        String wysiwygEditor = CmsPropertyHandler.getWysiwygEditor();
        if (wysiwygEditor == null || wysiwygEditor.equalsIgnoreCase("") || wysiwygEditor.equalsIgnoreCase("HTMLArea")) {
            return "success";
        }
        return "successForFCKEditor";
    }

    public String doStandalone() throws Exception {
        this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId);
        String wysiwygEditor = CmsPropertyHandler.getWysiwygEditor();
        if (wysiwygEditor == null || wysiwygEditor.equalsIgnoreCase("") || wysiwygEditor.equalsIgnoreCase("HTMLArea")) {
            return "standalone";
        }
        return "standaloneForFCKEditor";
    }

    public String doBackground() throws Exception {
        this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId);
        return "background";
    }

    public String doViewAssetsDialog() throws Exception {
        if (this.oldContentId != null) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getOldContentId());
        } else if (this.getContentId() != null && this.getContentId() != -1) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getContentId());
        }
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "viewAssetsDialog";
    }

    public String doViewAssetsDialogForFCKEditor() throws Exception {
        if (this.oldContentId != null) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getOldContentId());
        } else if (this.getContentId() != null && this.getContentId() != -1) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getContentId());
        }
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "viewAssetsDialogForFCKEditor";
    }

    public String doViewAssetsForComponentBinding() throws Exception {
        if (this.oldContentId != null) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getOldContentId());
        } else if (this.getContentId() != null && this.getContentId() != -1) {
            this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getContentId());
        }
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "showContentAssetsForComponentBinding";
    }

    public String doViewAssets() throws Exception {
        if (this.getContentId() != null && this.getContentId() != -1) {
            this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId, true, false);
        }
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        return "viewAssets";
    }

    public String doViewAssetsForFCKEditor() throws Exception {
        if (this.getContentId() != null && this.getContentId() != -1) {
            this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId, true, false);
        }
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        if (this.assetKey != null) {
            String toEncoding;
            String fromEncoding = CmsPropertyHandler.getAssetKeyFromEncoding();
            if (fromEncoding == null) {
                fromEncoding = "iso-8859-1";
            }
            if ((toEncoding = CmsPropertyHandler.getAssetKeyToEncoding()) == null) {
                toEncoding = "utf-8";
            }
            this.assetKey = new String(this.assetKey.getBytes(fromEncoding), toEncoding);
        }
        return "viewAssetsForFCKEditor";
    }

    public String doPreview() throws Exception {
        this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId);
        return "preview";
    }

    public String doAsXML() throws Exception {
        this.initialize(this.getContentVersionId(), this.getContentId(), this.languageId);
        return "asXML";
    }

    public String doDeleteDigitalAsset() throws Exception {
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().deleteDigitalAssetRelation(this.getContentVersionId(), this.digitalAssetId, this.getInfoGluePrincipal());
        this.setContentVersionId(contentVersionVO.getId());
        this.anchor = "digitalAssetsBlock";
        if (this.returnAddress != null && !this.returnAddress.equals("")) {
            this.getResponse().sendRedirect(String.valueOf(this.returnAddress) + "#" + this.anchor);
            return "none";
        }
        return this.doExecute();
    }

    public String doDeleteDigitalAssetStandalone() throws Exception {
        ContentVersionController.getContentVersionController().deleteDigitalAssetRelation(this.getContentVersionId(), this.digitalAssetId, this.getInfoGluePrincipal());
        this.anchor = "digitalAssetsBlock";
        return this.doStandalone();
    }

    public EventVO getEvent(Integer contentVersionId) {
        EventVO eventVO = null;
        try {
            if (contentVersionId != null) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId);
                List events = EventController.getEventVOListForEntity(ContentVersion.class.getName(), contentVersion.getId());
                if (events != null && events.size() > 0) {
                    eventVO = (EventVO)events.get(0);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get any events for this version:" + e.getMessage()), (Throwable)e);
        }
        return eventVO;
    }

    public List getContentPath() {
        ContentVO contentVO = this.contentVO;
        ArrayList<ContentVO> ret = new ArrayList<ContentVO>();
        while (contentVO.getParentContentId() != null) {
            try {
                contentVO = ContentControllerProxy.getController().getContentVOWithId(contentVO.getParentContentId());
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
            catch (Bug e) {
                e.printStackTrace();
            }
            ret.add(0, contentVO);
        }
        return ret;
    }

    public Integer getContentVersionId() {
        if (this.contentVersionVO != null) {
            return this.contentVersionVO.getContentVersionId();
        }
        return null;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionVO.setContentVersionId(contentVersionId);
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionVO.getContentTypeDefinitionId();
    }

    public String getContentTypeDefinitionName() {
        return this.contentTypeDefinitionVO.getName();
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setStateId(Integer stateId) {
        if (this.contentVersionVO != null) {
            this.contentVersionVO.setStateId(stateId);
        }
    }

    public void setVersionComment(String versionComment) {
        if (this.contentVersionVO != null) {
            this.contentVersionVO.setVersionComment(versionComment);
        }
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }

    public String getVersionComment() {
        return this.contentVersionVO.getVersionComment();
    }

    public Integer getStateId() {
        return this.contentVersionVO.getStateId();
    }

    public Boolean getIsActive() {
        return this.contentVersionVO.getIsActive();
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public Integer getRepositoryId() {
        if (this.contentVO != null && this.contentVO.getRepositoryId() != null) {
            return this.contentVO.getRepositoryId();
        }
        return this.repositoryId;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public List getDigitalAssets() {
        List digitalAssets = null;
        try {
            if (this.contentVersionVO != null && this.contentVersionVO.getContentVersionId() != null) {
                digitalAssets = DigitalAssetController.getDigitalAssetVOList(this.contentVersionVO.getContentVersionId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public List getInheritedDigitalAssets() {
        List digitalAssets = null;
        try {
            if (this.contentVO != null && this.contentVO.getContentId() != null && this.contentVO.getContentId() != -1) {
                digitalAssets = DigitalAssetController.getDigitalAssetVOList(this.contentVO.getContentId(), this.languageId, true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public String getDigitalAssetUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetUrl(Integer contentId, Integer languageId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(contentId, languageId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetUrl(Integer contentId, Integer languageId, String assetKey) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(contentId, languageId, assetKey, false);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer contentId, Integer languageId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(contentId, languageId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer contentId, Integer languageId, String assetKey) throws Exception {
        String imageHref = null;
        try {
            DigitalAssetVO assetVO = DigitalAssetController.getDigitalAssetVO(contentId, languageId, assetKey, false);
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(assetVO.getDigitalAssetId());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getAttributeValue(String key) {
        String value = "";
        if (this.contentVersionVO != null) {
            try {
                logger.info((Object)("key:" + key));
                logger.info((Object)("VersionValue:" + this.contentVersionVO.getVersionValue()));
                String xml = this.contentVersionVO.getVersionValue();
                int startTagIndex = xml.indexOf("<" + key + ">");
                int endTagIndex = xml.indexOf("]]></" + key + ">");
                if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                    value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
                    value = new VisualFormatter().escapeHTML(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("value:" + value));
        return value;
    }

    public String getUnescapedAttributeValue(String key) {
        String value = "";
        if (this.contentVersionVO != null) {
            try {
                logger.info((Object)("key:" + key));
                logger.info((Object)("VersionValue:" + this.contentVersionVO.getVersionValue()));
                String xml = this.contentVersionVO.getVersionValue();
                int startTagIndex = xml.indexOf("<" + key + ">");
                int endTagIndex = xml.indexOf("]]></" + key + ">");
                if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                    value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public String getOriginalLanguageAttributeValue(String key) {
        String value = "";
        if (this.originalLanguageContentVersionVO != null) {
            try {
                logger.info((Object)("key:" + key));
                String xml = this.originalLanguageContentVersionVO.getVersionValue();
                int startTagIndex = xml.indexOf("<" + key + ">");
                int endTagIndex = xml.indexOf("]]></" + key + ">");
                if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                    value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
                    value = new VisualFormatter().escapeHTML(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("value:" + value));
        return value;
    }

    public String getOriginalLanguageUnescapedAttributeValue(String key) {
        String value = "";
        if (this.originalLanguageContentVersionVO != null) {
            try {
                logger.info((Object)("key:" + key));
                String xml = this.originalLanguageContentVersionVO.getVersionValue();
                int startTagIndex = xml.indexOf("<" + key + ">");
                int endTagIndex = xml.indexOf("]]></" + key + ">");
                if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                    value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public List getContentTypeAttributes() {
        return this.attributes;
    }

    public ContentVersionVO getContentVersionVO() {
        return this.contentVersionVO;
    }

    public Map getWYSIWYGProperties() throws Exception {
        if (this.WYSIWYGProperties != null) {
            return this.WYSIWYGProperties;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        byte[] WYSIWYGConfigBytes = ps.getData("repository_" + this.getRepositoryId() + "_WYSIWYGConfig");
        if (WYSIWYGConfigBytes != null) {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(WYSIWYGConfigBytes));
            this.WYSIWYGProperties = properties;
        }
        Map principalWYSIWYGProperties = this.getPrincipalPropertyHashValues("WYSIWYGConfig", false);
        if (this.WYSIWYGProperties != null) {
            int index;
            logger.info((Object)("this.WYSIWYGProperties:" + this.WYSIWYGProperties.size()));
            if (principalWYSIWYGProperties.containsKey("toolbar_line0_position0")) {
                int lineIndex = 0;
                while (lineIndex < 3) {
                    int colIndex = 0;
                    while (colIndex < 30) {
                        this.WYSIWYGProperties.remove("toolbar_line" + lineIndex + "_position" + colIndex);
                        ++colIndex;
                    }
                    ++lineIndex;
                }
            }
            if (principalWYSIWYGProperties.containsKey("css.url.0")) {
                index = 0;
                while (index < 10) {
                    this.WYSIWYGProperties.remove("css.url." + index);
                    ++index;
                }
            }
            if (principalWYSIWYGProperties.containsKey("css.class.0")) {
                index = 0;
                while (index < 50) {
                    this.WYSIWYGProperties.remove("css.class." + index);
                    ++index;
                }
            }
        } else {
            this.WYSIWYGProperties = new HashMap();
        }
        this.WYSIWYGProperties.putAll(principalWYSIWYGProperties);
        return this.WYSIWYGProperties;
    }

    public List getCSSRules(String url) {
        logger.info((Object)("url:" + url));
        CSSHelper cssHelper = CSSHelper.getHelper();
        cssHelper.setCSSUrl(url);
        return cssHelper.getCSSRules();
    }

    public boolean getEnableCSSPlugin() throws Exception {
        boolean enableCSSPlugin = false;
        Map properties = this.getWYSIWYGProperties();
        String enableCSSPluginString = (String)properties.get("enableCSSPlugin");
        if (enableCSSPluginString != null && enableCSSPluginString.trim().equalsIgnoreCase("true")) {
            enableCSSPlugin = true;
        }
        return enableCSSPlugin;
    }

    public List getCSSList() throws Exception {
        ArrayList<String> cssList = new ArrayList<String>();
        Map properties = this.getWYSIWYGProperties();
        int index = 0;
        String cssUrl = (String)properties.get("css.url." + index);
        while (cssUrl != null) {
            cssList.add(cssUrl);
            cssUrl = (String)properties.get("css.url." + ++index);
        }
        return cssList;
    }

    public List getAllowedClasses() throws Exception {
        ArrayList<String> allowedClasses = new ArrayList<String>();
        Map properties = this.getWYSIWYGProperties();
        int index = 0;
        String cssUrl = (String)properties.get("css.class." + index);
        while (cssUrl != null) {
            allowedClasses.add(cssUrl);
            cssUrl = (String)properties.get("css.class." + ++index);
        }
        return allowedClasses;
    }

    public String getDeliveryBaseUrl() {
        String previewDeliveryUrl = CmsPropertyHandler.getPreviewDeliveryUrl();
        int index = previewDeliveryUrl.lastIndexOf("/");
        if (index > 0) {
            previewDeliveryUrl = previewDeliveryUrl.substring(0, index);
        }
        return previewDeliveryUrl;
    }

    public List getDefinedCategoryKeys() {
        try {
            if (this.contentTypeDefinitionVO != null) {
                return ContentTypeDefinitionController.getController().getDefinedCategoryKeys(this.contentTypeDefinitionVO.getSchemaValue());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public List getAvailableCategories(Integer categoryId) {
        try {
            String protectCategories = CmsPropertyHandler.getProtectCategories();
            if (protectCategories != null && protectCategories.equalsIgnoreCase("true")) {
                return categoryController.getAuthorizedActiveChildren(categoryId, this.getInfoGluePrincipal());
            }
            return categoryController.findAllActiveChildren(categoryId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of categories: " + e.getMessage()), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public List getRelatedCategories(String attribute) {
        try {
            if (this.contentVersionVO != null && this.contentVersionVO.getContentVersionId() != null) {
                return contentCategoryController.findByContentVersionAttribute(attribute, this.contentVersionVO.getContentVersionId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public ContentVersionVO getMasterContentVersionVO(Integer contentId, Integer repositoryId) throws SystemException, Exception {
        LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(repositoryId);
        return ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguageVO.getId());
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId) throws SystemException, Exception {
        return ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
    }

    public Integer getCurrentEditorId() {
        return this.currentEditorId;
    }

    public void setCurrentEditorId(Integer integer) {
        this.currentEditorId = integer;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getTextAreaId() {
        return this.textAreaId;
    }

    public void setTextAreaId(String textAreaId) {
        this.textAreaId = textAreaId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public void setAssetKey(String assetKey) {
        this.assetKey = assetKey;
    }

    public Integer getOldContentId() {
        return this.oldContentId;
    }

    public void setOldContentId(Integer oldContentId) {
        this.oldContentId = oldContentId;
    }

    public boolean getTreatAsLink() {
        return this.treatAsLink;
    }

    public void setTreatAsLink(boolean treatAsLink) {
        this.treatAsLink = treatAsLink;
    }

    public ContentVO getContentVO() {
        return this.contentVO;
    }

    public String getCloseOnLoad() {
        return this.closeOnLoad;
    }

    public void setCloseOnLoad(String closeOnLoad) {
        this.closeOnLoad = closeOnLoad;
    }

    public Integer getNewContentId() {
        return this.newContentId;
    }

    public void setNewContentId(Integer newContentId) {
        this.newContentId = newContentId;
    }

    public void setContentVersionVO(ContentVersionVO contentVersionVO) {
        this.contentVersionVO = contentVersionVO;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }

    public boolean getConcurrentModification() {
        return this.concurrentModification;
    }

    public void setConcurrentModification(boolean concurrentModification) {
        this.concurrentModification = concurrentModification;
    }

    public long getOldModifiedDateTime() {
        return this.oldModifiedDateTime;
    }

    public void setOldModifiedDateTime(long oldModifiedDateTime) {
        this.oldModifiedDateTime = oldModifiedDateTime;
    }

    public void setForceWorkingChange(boolean forceWorkingChange) {
        this.forceWorkingChange = forceWorkingChange;
    }

    public String getPublishOnLoad() {
        return this.publishOnLoad;
    }

    public void setPublishOnLoad(String publishOnLoad) {
        this.publishOnLoad = publishOnLoad;
    }

    public boolean getIsAssetBinding() {
        return this.isAssetBinding;
    }

    public void setIsAssetBinding(boolean isAssetBinding) {
        this.isAssetBinding = isAssetBinding;
    }

    public Integer getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Integer componentId) {
        this.componentId = componentId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public boolean getShowSimple() {
        return this.showSimple;
    }

    public void setShowSimple(boolean showSimple) {
        this.showSimple = showSimple;
    }

    public String getAssignedAssetKey() {
        return this.assignedAssetKey;
    }

    public void setAssignedAssetKey(String assignedAssetKey) {
        this.assignedAssetKey = assignedAssetKey;
    }

    public String getAssignedPath() {
        return this.assignedPath;
    }

    public void setAssignedPath(String assignedPath) {
        this.assignedPath = assignedPath;
    }

    public Integer getAssignedContentId() {
        return this.assignedContentId;
    }

    public void setAssignedContentId(Integer assignedContentId) {
        this.assignedContentId = assignedContentId;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public boolean getShowActionButtons() {
        return this.showActionButtons;
    }

    public void setShowActionButtons(boolean showActionButtons) {
        this.showActionButtons = showActionButtons;
    }

    public boolean getShowSelectButtonByEachImage() {
        return this.showSelectButtonByEachImage;
    }

    public void setShowSelectButtonByEachImage(boolean showSelectButtonByEachImage) {
        this.showSelectButtonByEachImage = showSelectButtonByEachImage;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    public boolean getTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public Integer getFromLanguageId() {
        return this.fromLanguageId;
    }

    public void setFromLanguageId(Integer fromLanguageId) {
        this.fromLanguageId = fromLanguageId;
    }

    public Integer getToLanguageId() {
        return this.toLanguageId;
    }

    public void setToLanguageId(Integer toLanguageId) {
        this.toLanguageId = toLanguageId;
    }

    public ContentVersionVO getOriginalLanguageContentVersionVO() {
        return this.originalLanguageContentVersionVO;
    }

    public LanguageVO getCurrentLanguageVO() {
        return this.currentLanguageVO;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }
}

