/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.ImageButton;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewContentToolToolBarAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentToolToolBarAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String title = "";
    private String name = "";
    private String toolbarKey = "";
    private String url = "";
    private Boolean isBranch = new Boolean(false);
    private Integer repositoryId = null;
    private Integer siteNodeId = null;
    private Integer languageId = null;
    private Integer contentId = null;
    private Integer contentVersionId = null;
    private Integer lastPublishedContentVersionId = null;
    private String languageName = "";
    private String extraInformation = "";
    private ContentVO contentVO = null;

    public String doExecute() throws Exception {
        if (this.contentId != null) {
            this.contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
        }
        if (this.repositoryId == null && this.contentId != null) {
            this.repositoryId = ContentController.getContentController().getContentVOWithId(this.contentId).getRepositoryId();
            SiteNodeVO rootSiteNodeVO = SiteNodeController.getController().getRootSiteNodeVO(this.repositoryId);
            if (rootSiteNodeVO != null) {
                this.siteNodeId = rootSiteNodeVO.getId();
            }
        }
        return "success";
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsBranch() {
        return this.isBranch;
    }

    public void setIsBranch(Boolean isBranch) {
        this.isBranch = isBranch;
    }

    public String getToolbarKey() {
        return this.toolbarKey;
    }

    public void setToolbarKey(String toolbarKey) {
        this.toolbarKey = toolbarKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public List getButtons() {
        logger.info((Object)("Title:" + this.title));
        logger.info((Object)("toolbarKey:" + this.toolbarKey));
        if (this.toolbarKey.equalsIgnoreCase("content details")) {
            if (this.isBranch.booleanValue()) {
                return this.getBranchContentButtons();
            }
            return this.getContentButtons();
        }
        if (this.toolbarKey.equalsIgnoreCase("content version")) {
            return this.getContentVersionButtons();
        }
        if (this.toolbarKey.equalsIgnoreCase("ContentVersionHistory")) {
            return this.getContentVersionHistoryButtons();
        }
        return null;
    }

    private boolean hasAnyPublishedVersion() {
        boolean hasPublishedVersion = false;
        try {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestPublishedContentVersion(this.contentId);
            if (contentVersion != null) {
                hasPublishedVersion = true;
                this.lastPublishedContentVersionId = contentVersion.getContentVersionId();
                this.repositoryId = contentVersion.getOwningContent().getRepository().getId();
                this.name = contentVersion.getOwningContent().getName();
                this.languageName = contentVersion.getLanguage().getName();
                this.contentId = contentVersion.getOwningContent().getId();
                this.languageId = contentVersion.getLanguage().getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasPublishedVersion;
    }

    private boolean hasPublishedVersion() {
        boolean hasPublishedVersion = false;
        try {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestPublishedContentVersion(this.contentId, this.languageId);
            if (contentVersion != null) {
                hasPublishedVersion = true;
                this.lastPublishedContentVersionId = contentVersion.getContentVersionId();
                this.repositoryId = contentVersion.getOwningContent().getRepository().getId();
                this.name = contentVersion.getOwningContent().getName();
                this.languageName = contentVersion.getLanguage().getName();
                this.contentId = contentVersion.getOwningContent().getId();
                this.languageId = contentVersion.getLanguage().getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasPublishedVersion;
    }

    private boolean hasVersion() {
        boolean hasVersion = false;
        try {
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.contentId, this.languageId);
            if (contentVersionVO != null) {
                hasVersion = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasVersion;
    }

    private boolean isReadOnly() {
        boolean isReadOnly = false;
        try {
            ContentVersionVO contentVersion = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
            if (contentVersion != null && (contentVersion.getStateId() == 1 || contentVersion.getStateId() == 2 || contentVersion.getStateId() == 3)) {
                isReadOnly = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isReadOnly;
    }

    private List getBranchContentButtons() {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        try {
            buttons.add(new ImageButton("CreateContent!input.action?isBranch=false&parentContentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.newContent"), "tool.contenttool.newContent.header"));
            buttons.add(new ImageButton("CreateContent!input.action?isBranch=true&parentContentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.newContentFolder"), "tool.contenttool.newContentFolder.header"));
            ImageButton moveButton = this.getMoveButton();
            moveButton.getSubButtons().add(this.getMoveMultipleButton());
            buttons.add(moveButton);
            ImageButton deleteButton = this.getDeleteButton();
            ImageButton deleteChildrenButton = this.getDeleteChildrenButton();
            deleteButton.getSubButtons().add(deleteChildrenButton);
            buttons.add(deleteButton);
            buttons.add(this.getPublishButton());
            ImageButton unpublishButton = this.getUnpublishButton();
            ImageButton unpublishAllButton = this.getUnpublishAllButton();
            unpublishButton.getSubButtons().add(unpublishAllButton);
            buttons.add(unpublishButton);
            buttons.add(new ImageButton("ViewContentProperties.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.global.buttons.editProperties"), "Edit Properties", new Integer(22), new Integer(80)));
            if (this.contentVO.getIsProtected().intValue() == ContentVO.YES.intValue()) {
                buttons.add(this.getAccessRightsButton());
            }
            buttons.add(new ImageButton("ViewContentVersionHistory.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.viewHistory"), "History", new Integer(22), new Integer(80)));
            buttons.add(this.getSyncTreeButton());
            buttons.add(this.getExecuteTaskButton());
            buttons.add(new ImageButton("UpdateContent!inputContentType.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.changeContentType"), "tool.contenttool.changeContentType.header"));
            if (AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "ContentTool.ImportExport", true)) {
                ImageButton exportButton = new ImageButton("ExportContent!input.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.exportContent"), "tool.contenttool.exportContent.header");
                ImageButton importButton = new ImageButton("ImportContent!input.action?parentContentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.importContent"), "tool.contenttool.importContent.header");
                exportButton.getSubButtons().add(importButton);
                buttons.add(exportButton);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return buttons;
    }

    private List getContentButtons() {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        try {
            buttons.add(this.getDeleteButton());
            ImageButton moveButton = this.getMoveButton();
            moveButton.getSubButtons().add(this.getMoveMultipleButton());
            buttons.add(moveButton);
            buttons.add(this.getPublishButton());
            if (this.hasAnyPublishedVersion()) {
                ImageButton unpublishButton = this.getUnpublishButton();
                ImageButton unpublishAllButton = this.getUnpublishAllButton();
                unpublishButton.getSubButtons().add(unpublishAllButton);
                buttons.add(unpublishButton);
            }
            if (this.contentVO.getIsProtected().intValue() == ContentVO.YES.intValue()) {
                buttons.add(this.getAccessRightsButton());
            }
            buttons.add(new ImageButton("ViewContentVersionHistory.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.viewHistory"), "History", new Integer(22), new Integer(80)));
            buttons.add(this.getSyncTreeButton());
            buttons.add(this.getExecuteTaskButton());
            buttons.add(new ImageButton("UpdateContent!inputContentType.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.changeContentType"), "tool.contenttool.changeContentType.header"));
            ImageButton exportButton = new ImageButton("ExportContent!input.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.exportContent"), "tool.contenttool.exportContent.header");
            ImageButton importButton = new ImageButton("ImportContent!input.action?parentContentId=" + this.contentId + "&repositoryId=" + this.repositoryId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.importContent"), "tool.contenttool.importContent.header");
            exportButton.getSubButtons().add(importButton);
            buttons.add(exportButton);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return buttons;
    }

    private List getContentVersionButtons() {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        try {
            boolean latest = true;
            if (this.contentVersionId != null) {
                ContentVersionVO currentContentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
                ContentVersionVO latestContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(currentContentVersionVO.getContentId(), currentContentVersionVO.getLanguageId());
                if (currentContentVersionVO.getId().intValue() != latestContentVersionVO.getId().intValue()) {
                    latest = false;
                }
                this.extraInformation = this.getStateDescription(currentContentVersionVO);
            }
            buttons.add(this.getCoverButton());
            if (latest) {
                buttons.add(this.getDeleteButton());
                if (this.contentVersionId != null) {
                    if (!this.isReadOnly()) {
                        buttons.add(new ImageButton(true, "javascript:openPopup('ViewDigitalAsset.action?contentVersionId=" + this.contentVersionId + "', 'FileUpload', 'width=400,height=200,resizable=no');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.newAsset"), "tool.contenttool.uploadDigitalAsset.header"));
                    }
                    if (this.siteNodeId != null) {
                        int startIndex;
                        RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(this.repositoryId);
                        String dnsName = repositoryVO.getDnsName();
                        String workingUrl = null;
                        String keyword = "working=";
                        int n = startIndex = dnsName == null ? -1 : dnsName.indexOf(keyword);
                        if (startIndex != -1) {
                            int endIndex = dnsName.indexOf(",", startIndex);
                            dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                            workingUrl = String.valueOf(dnsName.split("=")[1]) + CmsPropertyHandler.getComponentRendererUrl() + "ViewPage.action";
                        } else {
                            workingUrl = CmsPropertyHandler.getPreviewDeliveryUrl();
                        }
                        ImageButton previewSiteButton = new ImageButton(true, "javascript:openPopup('" + workingUrl + "?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "', 'SitePreview', 'width=800,height=600,resizable=yes,toolbar=yes,scrollbars=yes,status=yes,location=yes,menubar=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.previewSite"), "tool.contenttool.previewSite.header");
                        ImageButton previewContentButton = new ImageButton(true, "javascript:openPopup('ViewContentVersion!preview.action?contentVersionId=" + this.contentVersionId + "&contentId=" + this.contentId + "&languageId=" + this.languageId + "', 'ContentPreview', 'width=800,height=600,resizable=yes,toolbar=yes,scrollbars=yes,status=yes,location=yes,menubar=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.previewContent"), "tool.contenttool.previewContent.header");
                        previewSiteButton.getSubButtons().add(previewContentButton);
                        buttons.add(previewSiteButton);
                    }
                    if (this.hasPublishedVersion()) {
                        ImageButton unpublishButton = this.getUnpublishButton();
                        ImageButton unpublishAllButton = this.getUnpublishAllButton();
                        unpublishButton.getSubButtons().add(unpublishAllButton);
                        buttons.add(unpublishButton);
                    }
                    if (this.contentVO.getIsProtected().intValue() == ContentVO.YES.intValue()) {
                        buttons.add(this.getContentVersionAccessRightsButton());
                    }
                    if (!this.isReadOnly()) {
                        buttons.add(this.getPublishButton());
                    }
                }
                buttons.add(this.getSyncTreeButton());
                if (this.hasVersion()) {
                    buttons.add(this.getChangeLanguageButton());
                    buttons.add(this.getShowXMLButton());
                }
            } else {
                buttons.add(this.getDeleteVersionButton());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return buttons;
    }

    private List getContentVersionHistoryButtons() {
        ArrayList<ImageButton> buttons = new ArrayList<ImageButton>();
        try {
            buttons.add(this.getCompareButton());
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when generating buttons:" + e.getMessage()), (Throwable)e);
        }
        return buttons;
    }

    private ImageButton getCompareButton() {
        return new ImageButton(true, "javascript:compareVersions('contentVersion');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.compareVersions"), "tool.contenttool.compareVersions.header");
    }

    private ImageButton getCoverButton() {
        try {
            return new ImageButton("ViewContent.action?contentId=" + this.contentId + "&stay=true", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.contentCover"), "tool.contenttool.contentDetailsHeader");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageButton getUnpublishButton() {
        try {
            return new ImageButton("UnpublishContentVersion!input.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.unpublishVersion"), "tool.contenttool.unpublishVersion.header");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageButton getUnpublishAllButton() {
        try {
            return new ImageButton("UnpublishContentVersion!inputChooseContents.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.unpublishAllVersion"), "tool.contenttool.unpublishAllVersion.header");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageButton getDeleteButton() {
        try {
            String url = "Confirm.action?header=tool.contenttool.deleteContent.header&yesDestination=" + URLEncoder.encode(URLEncoder.encode("DeleteContent.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&changeTypeId=4", "UTF-8"), "UTF-8") + "&noDestination=" + URLEncoder.encode(URLEncoder.encode("ViewContent.action?title=Content&contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, "UTF-8"), "UTF-8") + "&message=tool.contenttool.deleteContent.text";
            return new ImageButton(url, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.deleteContent"), "tool.contenttool.deleteContent.header");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageButton getDeleteChildrenButton() {
        try {
            String url = "Confirm.action?header=tool.contenttool.deleteContentChildren.header&yesDestination=" + URLEncoder.encode(URLEncoder.encode("DeleteContentChildren.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&changeTypeId=4", "UTF-8"), "UTF-8") + "&noDestination=" + URLEncoder.encode(URLEncoder.encode("ViewContent.action?title=Content&contentId=" + this.contentId + "&repositoryId=" + this.repositoryId, "UTF-8"), "UTF-8") + "&message=tool.contenttool.deleteContentChildren.text";
            return new ImageButton(url, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.deleteChildren"), "tool.contenttool.deleteChildren.header");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageButton getDeleteVersionButton() {
        try {
            String url = "Confirm.action?header=tool.contenttool.deleteContentVersion.header&yesDestination=" + URLEncoder.encode(URLEncoder.encode("DeleteContentVersion.action?contentVersionId=" + this.contentVersionId + "&repositoryId=" + this.repositoryId + "&contentId=" + this.contentId, "UTF-8"), "UTF-8") + "&noDestination=" + URLEncoder.encode(URLEncoder.encode("ViewContentVersionHistory.action", "UTF-8"), "UTF-8") + "&message=tool.contenttool.deleteContentVersion.text";
            return new ImageButton(url, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.deleteContentVersion"), "tool.contenttool.deleteContentVersion.header");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageButton getMoveButton() {
        return new ImageButton(true, "javascript:openPopup('ViewContentTree.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&hideLeafs=true', 'MoveContent', 'width=400,height=600,resizable=no');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.moveContent"), "tool.contenttool.moveContent.header");
    }

    private ImageButton getMoveMultipleButton() {
        return new ImageButton(true, "javascript:openPopup('MoveMultipleContent!input.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "', 'MoveMultipleContent', 'width=400,height=600,resizable=no');", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.moveMultipleContent"), "tool.contenttool.moveMultipleContent.header");
    }

    private ImageButton getSyncTreeButton() {
        return new ImageButton(true, "javascript:parent.frames['main'].syncWithTree();", this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.revealInTree"), "tool.contenttool.revealInTree.header");
    }

    private ImageButton getChangeLanguageButton() {
        return new ImageButton("ChangeVersionLanguage!input.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&contentVersionId=" + this.contentVersionId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.changeVersionLanguage"), "tool.contenttool.changeVersionLanguage.header");
    }

    private ImageButton getShowXMLButton() {
        return new ImageButton("ViewContentVersion!asXML.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&contentVersionId=" + this.contentVersionId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.showVersionAsXml"), "tool.contenttool.showVersionAsXml.header");
    }

    private ImageButton getPublishButton() {
        return new ImageButton("ViewListContentVersion.action?contentId=" + this.contentId, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.publishContent"), "tool.contenttool.publishContent.header");
    }

    private ImageButton getExecuteTaskButton() {
        return new ImageButton(true, "javascript:openPopup('ViewExecuteTask.action?contentId=" + this.contentId + "', 'ExecuteTask', 'width=400,height=600,resizable=yes,scrollbars=yes');", this.getLocalizedString(this.getSession().getLocale(), "images.global.buttons.executeTask"), "tool.common.executeTask.header");
    }

    private ImageButton getAccessRightsButton() throws Exception {
        String returnAddress = URLEncoder.encode(URLEncoder.encode("ViewContent.action?contentId=" + this.contentId + "&repositoryId=" + this.repositoryId + "&stay=true", "UTF-8"), "UTF-8");
        return new ImageButton("ViewAccessRights.action?interceptionPointCategory=Content&extraParameters=" + this.contentId + "&colorScheme=ContentTool&returnAddress=" + returnAddress, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.contentAccessRights"), "tool.contenttool.contentAccessRights.header");
    }

    private ImageButton getContentVersionAccessRightsButton() throws Exception {
        String returnAddress = URLEncoder.encode(URLEncoder.encode("ViewContentVersion.action?contentVersionId=" + this.contentVersionId + "&contentId=" + this.contentId + "&languageId=" + this.languageId, "UTF-8"), "UTF-8");
        return new ImageButton("ViewAccessRights.action?interceptionPointCategory=ContentVersion&extraParameters=" + this.contentVersionId + "&colorScheme=ContentTool&returnAddress=" + returnAddress, this.getLocalizedString(this.getSession().getLocale(), "images.contenttool.buttons.contentAccessRights"), "tool.contenttool.contentVersionAccessRights.header");
    }

    public String getStateDescription(ContentVersionVO contentVersionVO) {
        String state = "";
        if (contentVersionVO != null) {
            if (contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                state = "<span style=\"color:#333333; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.working") + ")</span>";
            } else if (contentVersionVO.getStateId().equals(ContentVersionVO.FINAL_STATE)) {
                state = "<span style=\"color:#AAAAAA; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.final") + ")</span>";
            } else if (contentVersionVO.getStateId().equals(ContentVersionVO.PUBLISH_STATE)) {
                state = "<span style=\"color:#888888; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.publish") + ")</span>";
            } else if (contentVersionVO.getStateId().equals(ContentVersionVO.PUBLISHED_STATE)) {
                state = "<span style=\"color:#666666; font-weight: bold;\">(" + this.getLocalizedString(this.getSession().getLocale(), "tool.contenttool.state.published") + ")</span>";
            }
        }
        return state;
    }

    public String getExtraInformation() {
        return this.extraInformation;
    }
}

