/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.frovi.ss.Tree.BaseNode;
import com.frovi.ss.Tree.BaseNodeSupplier;
import com.frovi.ss.Tree.INodeSupplier;
import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.TreeViewAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryLanguageController;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.treeservice.ss.ContentNodeSupplier;
import org.infoglue.cms.treeservice.ss.ContentNodeVersionSupplier;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ViewContentToolMenuHtmlAction
extends TreeViewAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentToolMenuHtmlAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer repositoryId;
    private String showVersions;
    private String showLeafs = "yes";
    private String treeMode = "classic";
    private Integer select;
    private BaseNode rootNode = null;
    private String[] allowedContentTypeIds = null;
    private String bodyClass;

    public String doBindingView() throws Exception {
        super.doExecute();
        return "bindingView";
    }

    protected INodeSupplier getNodeSupplier() throws Exception, SystemException {
        if (this.getRepositoryId() == null || this.getRepositoryId() < 1) {
            return null;
        }
        if (this.showVersions == null || this.showVersions.equals("")) {
            this.showVersions = (String)this.getRequest().getSession().getAttribute("htmlTreeShowVersions");
        } else {
            this.getRequest().getSession().setAttribute("htmlTreeShowVersions", (Object)this.showVersions);
        }
        BaseNodeSupplier sup = null;
        if (this.showVersions != null && this.showVersions.equalsIgnoreCase("yes")) {
            sup = new ContentNodeVersionSupplier(this.getRepositoryId(), this.getInfoGluePrincipal().getName());
        } else {
            ContentNodeSupplier contentNodeSupplier = new ContentNodeSupplier(this.getRepositoryId(), this.getInfoGluePrincipal());
            contentNodeSupplier.setShowLeafs(this.showLeafs.compareTo("yes") == 0);
            contentNodeSupplier.setAllowedContentTypeIds(this.allowedContentTypeIds);
            sup = contentNodeSupplier;
        }
        String treeMode = CmsPropertyHandler.getTreeMode();
        if (treeMode != null) {
            this.setTreeMode(treeMode);
        }
        this.rootNode = sup.getRootNode();
        return sup;
    }

    public List getAvailableLanguages() throws Exception {
        return RepositoryLanguageController.getController().getRepositoryLanguageVOListWithRepositoryId(this.repositoryId);
    }

    public List getContentTypeDefinitions() throws Exception {
        return ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
    }

    public Integer getRepositoryId() {
        if (this.repositoryId == null) {
            try {
                List repositoryVOList = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
                if (repositoryVOList != null && repositoryVOList.size() > 0) {
                    this.repositoryId = ((RepositoryVO)repositoryVOList.get(0)).getId();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Could not fetch the master repository for the principal:" + e.getMessage()), (Throwable)e);
            }
        }
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getShowVersions() {
        return this.showVersions;
    }

    public void setShowVersions(String showVersions) {
        this.showVersions = showVersions;
    }

    public String getShowLeafs() {
        return this.showLeafs;
    }

    public void setShowLeafs(String showLeafs) {
        this.showLeafs = showLeafs;
    }

    public Integer getSelect() {
        return this.select;
    }

    public void setSelect(Integer select) {
        this.select = select;
    }

    public BaseNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(BaseNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getTreeMode() {
        return this.treeMode;
    }

    public void setTreeMode(String treeMode) {
        this.treeMode = treeMode;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public String getBodyClass() {
        return this.bodyClass;
    }

    public void setBodyClass(String bodyClass) {
        this.bodyClass = bodyClass;
    }
}

