/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGluePropertiesAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;

public class ViewContentPropertiesAction
extends InfoGluePropertiesAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentPropertiesAction.class.getName());
    private static final long serialVersionUID = 1L;
    private ContentVO contentVO = new ContentVO();
    private PropertySet propertySet = null;
    private List contentTypeDefinitionVOList = null;
    private List languageVOList = null;
    private String allowedContentTypeNames = null;
    private String defaultContentTypeName = null;
    private String initialLanguageId = null;

    protected void initialize(Integer contentId) throws Exception {
        this.contentVO = ContentController.getContentController().getContentVOWithId(contentId);
        this.contentTypeDefinitionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList(ContentTypeDefinitionVO.CONTENT);
        this.languageVOList = LanguageController.getController().getLanguageVOList(this.contentVO.getRepositoryId());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        if (ps.exists("content_" + this.getContentId() + "_allowedContentTypeNames")) {
            this.allowedContentTypeNames = ps.getString("content_" + this.getContentId() + "_allowedContentTypeNames");
        }
        this.defaultContentTypeName = ps.getString("content_" + this.getContentId() + "_defaultContentTypeName");
        this.initialLanguageId = ps.getString("content_" + this.getContentId() + "_initialLanguageId");
        logger.info((Object)("allowedContentTypeNames:" + this.allowedContentTypeNames));
        logger.info((Object)("defaultContentTypeName:" + this.defaultContentTypeName));
        logger.info((Object)("initialLanguageId:" + this.initialLanguageId));
    }

    public String doExecute() throws Exception {
        this.initialize(this.getContentId());
        return "success";
    }

    public String doSave() throws Exception {
        String allowedContentTypeNames = null;
        String[] allowedContentTypeNameArray = this.getRequest().getParameterValues("allowedContentTypeName");
        if (allowedContentTypeNameArray != null) {
            logger.info((Object)("allowedContentTypeNameArray:" + allowedContentTypeNameArray));
            allowedContentTypeNames = "";
            int i = 0;
            while (i < allowedContentTypeNameArray.length) {
                allowedContentTypeNames = String.valueOf(allowedContentTypeNames) + allowedContentTypeNameArray[i] + ",";
                ++i;
            }
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        if (allowedContentTypeNames != null) {
            ps.setString("content_" + this.getContentId() + "_allowedContentTypeNames", allowedContentTypeNames);
        }
        if (this.defaultContentTypeName != null) {
            ps.setString("content_" + this.getContentId() + "_defaultContentTypeName", this.defaultContentTypeName);
        }
        if (this.initialLanguageId != null) {
            ps.setString("content_" + this.getContentId() + "_initialLanguageId", this.initialLanguageId);
        }
        return "save";
    }

    public String doSaveAndExit() throws Exception {
        this.doSave();
        return "saveAndExit";
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public void setContentId(Integer contentId) throws Exception {
        this.contentVO.setContentId(contentId);
    }

    public ContentVO getContentVO() {
        return this.contentVO;
    }

    public List getContentTypeDefinitionVOList() {
        return this.contentTypeDefinitionVOList;
    }

    public String getAllowedContentTypeNames() {
        return this.allowedContentTypeNames;
    }

    public String getDefaultContentTypeName() {
        return this.defaultContentTypeName;
    }

    public void setDefaultContentTypeName(String defaultContentTypeName) {
        this.defaultContentTypeName = defaultContentTypeName;
    }

    public List getLanguageVOList() {
        return this.languageVOList;
    }

    public String getInitialLanguageId() {
        return this.initialLanguageId;
    }

    public void setInitialLanguageId(String initialLanguageId) {
        this.initialLanguageId = initialLanguageId;
    }
}

