/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.InfoGlueSettingsController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryLanguageController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class ViewContentAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewContentAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer unrefreshedContentId = new Integer(0);
    private Integer changeTypeId = new Integer(0);
    private Integer repositoryId = null;
    private List availableLanguages = null;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private String defaultFolderContentTypeName;
    private Integer languageId = null;
    private String stay = null;
    private List referenceBeanList = new ArrayList();
    private ContentVO contentVO;

    public ViewContentAction() {
        this(new ContentVO());
    }

    public ViewContentAction(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    protected void initialize(Integer contentId) throws Exception {
        this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), contentId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(contentId);
        this.availableLanguages = RepositoryLanguageController.getController().getAvailableLanguageVOListForRepositoryId(this.contentVO.getRepositoryId());
        if (this.repositoryId == null) {
            this.repositoryId = this.contentVO.getRepositoryId();
        }
        if (this.contentVO.getRepositoryId() != null && !this.hasAccessTo("Repository.Read", "" + this.contentVO.getRepositoryId())) {
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            ceb.add(new AccessConstraintException("Content.contentId", "1000"));
            ceb.throwIfNotEmpty();
        }
        if (this.getIsBranch().booleanValue()) {
            this.defaultFolderContentTypeName = InfoGlueSettingsController.getInfoGlueSettingsController().getProperty("repository_" + this.getRepositoryId() + "_defaultFolderContentTypeName", "applicationProperties", null, false, false, false, false, null);
        }
        this.referenceBeanList = RegistryController.getController().getReferencingObjectsForContent(contentId, 100);
    }

    public String doExecute() throws Exception {
        block6: {
            ContentVO contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getContentId());
            if (contentVO.getRepositoryId() != null && !this.hasAccessTo("Repository.Read", "" + contentVO.getRepositoryId())) {
                logger.error((Object)("The user " + this.getInfoGluePrincipal().getName() + " had no access to Repository.Read and " + this.contentVO.getRepositoryId() + ". Could be an hacker attempt."));
                AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
                ceb.add(new AccessConstraintException("Content.contentId", "1000"));
                ceb.throwIfNotEmpty();
            }
            if (this.stay != null && this.stay.equalsIgnoreCase("true") || contentVO.getIsBranch().booleanValue() || contentVO.getContentTypeDefinitionId() == null || !this.getShowContentVersionFirst().equalsIgnoreCase("true")) break block6;
            if (this.repositoryId == null) {
                this.repositoryId = contentVO.getRepositoryId();
            }
            this.languageId = this.getInitialLanguageVO().getId();
            return "viewVersion";
        }
        try {
            this.initialize(this.getContentId());
            return "success";
        }
        catch (ConstraintException ce) {
            throw ce;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "none";
        }
    }

    public String doStandalone() throws Exception {
        this.initialize(this.getContentId());
        return "standalone";
    }

    public String doV3() throws Exception {
        block6: {
            ContentVO contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), this.getContentId());
            if (contentVO.getRepositoryId() != null && !this.hasAccessTo("Repository.Read", "" + contentVO.getRepositoryId())) {
                logger.error((Object)("The user " + this.getInfoGluePrincipal().getName() + " had no access to Repository.Read and " + this.contentVO.getRepositoryId() + ". Could be an hacker attempt."));
                AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
                ceb.add(new AccessConstraintException("Content.contentId", "1000"));
                ceb.throwIfNotEmpty();
            }
            if (this.stay != null && this.stay.equalsIgnoreCase("true") || contentVO.getIsBranch().booleanValue() || contentVO.getContentTypeDefinitionId() == null || !this.getShowContentVersionFirst().equalsIgnoreCase("true")) break block6;
            if (this.repositoryId == null) {
                this.repositoryId = contentVO.getRepositoryId();
            }
            this.languageId = this.getInitialLanguageVO().getId();
            return "viewVersionV3";
        }
        try {
            this.initialize(this.getContentId());
            return "successV3";
        }
        catch (ConstraintException ce) {
            throw ce;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "none";
        }
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getUnrefreshedContentId() {
        return this.unrefreshedContentId;
    }

    public void setUnrefreshedContentId(Integer unrefreshedContentId) {
        this.unrefreshedContentId = unrefreshedContentId;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public Integer getNewContentId() {
        return this.contentVO.getId();
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public long getPublishDateTimeAsLong() {
        return this.contentVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.contentVO.getExpireDateTime().getTime();
    }

    public Boolean getIsBranch() {
        return this.contentVO.getIsBranch();
    }

    public Integer getIsProtected() {
        return this.contentVO.getIsProtected();
    }

    public ContentTypeDefinitionVO getContentTypeDefinition() {
        return this.contentTypeDefinitionVO;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the latest version for the content:" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    public EventVO getContentVersionEvent(Integer contentVersionId) {
        EventVO eventVO = null;
        try {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId);
            List events = EventController.getEventVOListForEntity(ContentVersion.class.getName(), contentVersion.getId());
            if (events != null && events.size() > 0) {
                eventVO = (EventVO)events.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get any events for this version:" + e.getMessage()), (Throwable)e);
        }
        return eventVO;
    }

    public EventVO getContentEvent(Integer contentId) {
        EventVO eventVO = null;
        try {
            List events = EventController.getEventVOListForEntity(Content.class.getName(), contentId);
            if (events != null && events.size() > 0) {
                eventVO = (EventVO)events.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get any events for this version:" + e.getMessage()), (Throwable)e);
        }
        return eventVO;
    }

    public Integer getMasterLanguageId() {
        try {
            return LanguageController.getController().getMasterLanguage(this.repositoryId).getLanguageId();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get master language for repository", (Throwable)e);
            return null;
        }
    }

    public ContentVO getContentVO() {
        return this.contentVO;
    }

    public List getContentTypeDefinitions() throws Exception {
        List contentTypeVOList = null;
        String protectContentTypes = CmsPropertyHandler.getProtectContentTypes();
        contentTypeVOList = protectContentTypes != null && protectContentTypes.equalsIgnoreCase("true") ? ContentTypeDefinitionController.getController().getAuthorizedContentTypeDefinitionVOList(this.getInfoGluePrincipal()) : ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        Collections.sort(contentTypeVOList, new ReflectionComparator("name"));
        return contentTypeVOList;
    }

    public List getContentPath() {
        ContentVO contentVO = this.contentVO;
        ArrayList<ContentVO> ret = new ArrayList<ContentVO>();
        while (contentVO.getParentContentId() != null) {
            try {
                contentVO = ContentControllerProxy.getController().getContentVOWithId(contentVO.getParentContentId());
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
            catch (Bug e) {
                e.printStackTrace();
            }
            ret.add(0, contentVO);
        }
        return ret;
    }

    public void setContentVO(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    public String getDefaultFolderContentTypeName() {
        return this.defaultFolderContentTypeName;
    }

    public String getShowContentVersionFirst() {
        return CmsPropertyHandler.getShowContentVersionFirst();
    }

    public LanguageVO getMasterLanguageVO() throws Exception {
        return LanguageController.getController().getMasterLanguage(this.repositoryId);
    }

    public LanguageVO getInitialLanguageVO() throws Exception {
        String initialLanguageId = InfoGlueSettingsController.getInfoGlueSettingsController().getProperty("content_" + this.getContentId() + "_initialLanguageId", "applicationProperties", null, false, false, false, false, null);
        ContentController.getContentController();
        ContentVO parentContentVO = ContentController.getParentContent(this.getContentId());
        while ((initialLanguageId == null || initialLanguageId.equalsIgnoreCase("-1")) && parentContentVO != null) {
            initialLanguageId = InfoGlueSettingsController.getInfoGlueSettingsController().getProperty("content_" + parentContentVO.getId() + "_initialLanguageId", "applicationProperties", null, false, false, false, false, null);
            ContentController.getContentController();
            parentContentVO = ContentController.getParentContent(parentContentVO.getId());
        }
        if (initialLanguageId != null && !initialLanguageId.equals("") && !initialLanguageId.equals("-1")) {
            return LanguageController.getController().getLanguageVOWithId(new Integer(initialLanguageId));
        }
        return LanguageController.getController().getMasterLanguage(this.repositoryId);
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getStay() {
        return this.stay;
    }

    public void setStay(String stay) {
        this.stay = stay;
    }

    public List getReferenceBeanList() {
        return this.referenceBeanList;
    }
}

