/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.util.MathHelper;

public class ViewAssetListAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewAssetListAction.class.getName());
    private static final long serialVersionUID = 1707633990701035545L;
    public ContentTypeDefinitionVO contentTypeDefinitionVO;
    private Integer maxResultCount = new Integer(20);
    public List availableLanguages = null;
    private Integer languageId;
    private Integer repositoryId;
    private ContentVO contentVO;
    public List attributes = null;
    private List repositories;
    private List filters;
    private String filter = "";
    private String assetKey = null;
    private boolean treatAsLink = false;
    private boolean showLeafs = false;
    private HashMap contentMap = new HashMap();

    public ViewAssetListAction() {
        this(new ContentVO());
    }

    public ViewAssetListAction(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    private void createContentIdList(ContentVO parent) throws ConstraintException, SystemException {
        this.contentMap.put(parent.getContentId(), parent.getName());
        List children = ContentControllerProxy.getController().getContentChildrenVOList(parent.getContentId());
        for (ContentVO cvo : children) {
            this.createContentIdList(cvo);
        }
    }

    protected void initialize(Integer contentId, Integer languageId) throws Exception {
        this.contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), contentId);
        this.createContentIdList(this.contentVO);
    }

    public String doExecute() throws Exception {
        if (this.getContentId() != null && this.getContentId() != -1) {
            this.initialize(this.getContentId(), this.languageId);
        }
        return "success";
    }

    public String doBrowser() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), true);
        this.filters = new ArrayList();
        this.filters.add(new FilterVO("All", ""));
        this.filters.add(new FilterVO("Images", "image/.*"));
        this.filters.add(new FilterVO("GIF Images", ".*gif"));
        this.filters.add(new FilterVO("JPEG Images", ".*jpeg"));
        this.filters.add(new FilterVO("PNG Images", ".*png"));
        this.filters.add(new FilterVO("Documents", ".*word.*|.*excel.*|.*pdf.*"));
        this.filters.add(new FilterVO("compressed", ".*compressed"));
        return "browser";
    }

    public String getContentPath(Integer contentId) throws ConstraintException, SystemException, Bug, Exception {
        ContentVO contentVO = ContentControllerProxy.getController().getACContentVOWithId(this.getInfoGluePrincipal(), contentId);
        StringBuffer ret = new StringBuffer();
        while (contentVO.getParentContentId() != null) {
            try {
                contentVO = ContentControllerProxy.getController().getContentVOWithId(contentVO.getParentContentId());
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
            catch (Bug e) {
                e.printStackTrace();
            }
            ret.insert(0, contentVO.getContentId() + ",");
        }
        ret.append("" + contentId);
        return ret.toString();
    }

    public MathHelper getMathHelper() {
        return new MathHelper();
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionVO.getContentTypeDefinitionId();
    }

    public String getContentTypeDefinitionName() {
        return this.contentTypeDefinitionVO.getName();
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public Integer getRepositoryId() {
        if (this.contentVO != null && this.contentVO.getRepositoryId() != null) {
            return this.contentVO.getRepositoryId();
        }
        return this.repositoryId;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public List getInheritedDigitalAssets() {
        ArrayList<DigitalAssetCollection> digitalAssets = new ArrayList<DigitalAssetCollection>();
        try {
            for (Integer _contentId : this.contentMap.keySet()) {
                DigitalAssetCollection collection = new DigitalAssetCollection(_contentId, (String)this.contentMap.get(_contentId));
                collection.setContentPath(this.getContentPath(_contentId));
                if (this.filter.length() > 0) {
                    for (DigitalAssetVO digitalAssetVO : DigitalAssetController.getDigitalAssetVOList(_contentId, this.languageId, true)) {
                        if (!digitalAssetVO.getAssetContentType().matches(this.filter)) continue;
                        collection.getAssets().add(digitalAssetVO);
                    }
                } else {
                    collection.getAssets().addAll(DigitalAssetController.getDigitalAssetVOList(_contentId, this.languageId, true));
                }
                ContentVersionVO contentVersionVO = this.getLatestContentVersionVO(_contentId);
                if (contentVersionVO != null) {
                    collection.setContentVersionId(contentVersionVO.getContentVersionId());
                    collection.setLocked(ContentVersionVO.WORKING_STATE.compareTo(contentVersionVO.getStateId()) != 0);
                }
                digitalAssets.add(collection);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of digitalAssets: " + e.getMessage()), (Throwable)e);
        }
        return digitalAssets;
    }

    public String getDigitalAssetUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer digitalAssetId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(digitalAssetId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetUrl(Integer contentId, Integer languageId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(contentId, languageId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public String getDigitalAssetThumbnailUrl(Integer contentId, Integer languageId) throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(contentId, languageId);
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
            imageHref = e.getMessage();
        }
        return imageHref;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public void setAssetKey(String assetKey) {
        this.assetKey = assetKey;
    }

    public boolean getTreatAsLink() {
        return this.treatAsLink;
    }

    public void setTreatAsLink(boolean treatAsLink) {
        this.treatAsLink = treatAsLink;
    }

    public ContentVO getContentVO() {
        return this.contentVO;
    }

    protected ContentVersionVO getLatestContentVersionVO(Integer contentId) throws SystemException, Exception {
        Integer contentVersionId = null;
        ContentVersionVO contentVersionVO = null;
        contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, this.languageId);
        Integer usedRepositoryId = this.repositoryId;
        if (this.repositoryId == null && this.contentVO != null) {
            usedRepositoryId = this.contentVO.getRepositoryId();
        }
        LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(usedRepositoryId);
        contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguageVO.getId());
        if (contentVersionVO != null) {
            contentVersionId = contentVersionVO.getContentVersionId();
        }
        if (contentVersionId != null) {
            contentVersionVO = ContentVersionControllerProxy.getController().getACContentVersionVOWithId(this.getInfoGluePrincipal(), contentVersionId);
        }
        return contentVersionVO;
    }

    public boolean isShowLeafs() {
        return this.showLeafs;
    }

    public void setShowLeafs(boolean showLeafs) {
        this.showLeafs = showLeafs;
    }

    public List getFilters() {
        return this.filters;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public class DigitalAssetCollection {
        List assets = new ArrayList();
        String contentPath = null;
        Integer contentId = null;
        Integer contentVersionId = null;
        boolean locked = false;
        Integer languageId = null;
        String contentName = null;

        public DigitalAssetCollection(Integer contentId, String contentName) {
            this.contentId = contentId;
            this.contentName = contentName;
        }

        public List getAssets() {
            return this.assets;
        }

        public void setAssets(List assets) {
            this.assets = assets;
        }

        public Integer getContentId() {
            return this.contentId;
        }

        public void setContentId(Integer contentId) {
            this.contentId = contentId;
        }

        public String getContentName() {
            return this.contentName;
        }

        public void setContentName(String contentName) {
            this.contentName = contentName;
        }

        public String getContentPath() {
            return this.contentPath;
        }

        public void setContentPath(String contentPath) {
            this.contentPath = contentPath;
        }

        public Integer getContentVersionId() {
            return this.contentVersionId;
        }

        public void setContentVersionId(Integer contentVersionId) {
            this.contentVersionId = contentVersionId;
        }

        public Integer getLanguageId() {
            return this.languageId;
        }

        public void setLanguageId(Integer languageId) {
            this.languageId = languageId;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }
    }

    public class FilterVO {
        private String name = null;
        private String value = null;

        public FilterVO(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

