/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.AccessRightVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;

public class ViewAccessRightsAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewAccessRightsAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer interceptionPointId = null;
    private String interceptionPointName = null;
    private String interceptionPointCategory = null;
    private String extraParameters = "";
    private String returnAddress;
    private String colorScheme;
    private List interceptionPointVOList = new ArrayList();
    private List roleList = null;
    private List groupList = null;
    private Collection accessRightsUserRows = null;

    public String doExecute() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (this.interceptionPointCategory.equalsIgnoreCase("Content")) {
            if (this.extraParameters == null || this.extraParameters.equals("")) {
                throw new SystemException("The content category must have a content id sent in so don't set 'Use extra data for access control' to no for those interception points.");
            }
            Integer contentId = new Integer(this.extraParameters);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!contentVO.getCreatorName().equalsIgnoreCase(this.getInfoGluePrincipal().getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentControllerProxy.getController().getIsContentProtected(contentId) && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.ChangeAccessRights", contentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1006"));
                }
            }
        } else if (this.interceptionPointCategory.equalsIgnoreCase("SiteNodeVersion")) {
            Integer protectedSiteNodeVersionId;
            if (this.extraParameters == null || this.extraParameters.equals("")) {
                throw new SystemException("The sitenode category must have a sitenode id sent in so don't set 'Use extra data for access control' to no for those interception points.");
            }
            Integer siteNodeVersionId = new Integer(this.extraParameters);
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(this.getInfoGluePrincipal().getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.ChangeAccessRights", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
        this.interceptionPointVOList = InterceptionPointController.getController().getInterceptionPointVOList(this.interceptionPointCategory);
        this.roleList = RoleControllerProxy.getController().getAllRoles();
        this.groupList = GroupControllerProxy.getController().getAllGroups();
        this.accessRightsUserRows = AccessRightController.getController().getAccessRightsUserRows(this.interceptionPointCategory, this.extraParameters);
        return "success";
    }

    public boolean getHasAccessRight(Integer interceptionPointId, String extraParameters, String roleName) throws SystemException, Bug {
        try {
            List accessRights = AccessRightController.getController().getAccessRightVOList(interceptionPointId, extraParameters, roleName);
            boolean hasAccessRight = accessRights.size() > 0;
            return hasAccessRight;
        }
        catch (Exception e) {
            logger.warn((Object)e);
            throw new SystemException(e);
        }
    }

    public Integer getAccessRightId(Integer interceptionPointId, String extraParameters) throws SystemException, Bug {
        List accessRights = AccessRightController.getController().getAccessRightVOListOnly(interceptionPointId, extraParameters);
        return accessRights.size() > 0 ? ((AccessRightVO)accessRights.get(0)).getAccessRightId() : null;
    }

    public Collection getAccessRightGroups(Integer accessRightId) throws SystemException, Bug {
        List accessRightGroups = AccessRightController.getController().getAccessRightGroupVOList(accessRightId);
        return accessRightGroups;
    }

    public List getRoleList() {
        return this.roleList;
    }

    public List getGroupList() {
        return this.groupList;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(String colorScheme) {
        this.colorScheme = colorScheme;
    }

    public Integer getInterceptionPointId() {
        return this.interceptionPointId;
    }

    public void setInterceptionPointId(Integer interceptionPointId) {
        this.interceptionPointId = interceptionPointId;
    }

    public String getExtraParameters() {
        return this.extraParameters;
    }

    public String getInterceptionPointName() {
        return this.interceptionPointName;
    }

    public void setExtraParameters(String extraParameters) {
        this.extraParameters = extraParameters;
    }

    public void setInterceptionPointName(String interceptionPointName) {
        this.interceptionPointName = interceptionPointName;
    }

    public String getInterceptionPointCategory() {
        return this.interceptionPointCategory;
    }

    public void setInterceptionPointCategory(String interceptionPointCategory) {
        this.interceptionPointCategory = interceptionPointCategory;
    }

    public List getInterceptionPointVOList() {
        return this.interceptionPointVOList;
    }

    public Collection getAccessRightsUserRows() {
        return this.accessRightsUserRows;
    }
}

