/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.contenttool.actions.ViewDigitalAssetAction;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import webwork.action.ActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class UpdateDigitalAssetAction
extends ViewDigitalAssetAction {
    private static final Logger logger = Logger.getLogger((String)UpdateDigitalAssetAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer contentVersionId = null;
    private Integer digitalAssetId = null;
    private String digitalAssetKey = null;
    private boolean isUpdated = false;
    private String reasonKey;
    private String uploadMaxSize;
    private DigitalAssetVO digitalAssetVO = null;
    private DigitalAssetVO updatedDigitalAssetVO = null;
    private String closeOnLoad;
    private Integer contentTypeDefinitionId;
    private VisualFormatter formatter = new VisualFormatter();
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();

    public void setDigitalAssetKey(String digitalAssetKey) {
        this.digitalAssetKey = digitalAssetKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doExecute() throws Exception {
        this.ceb.throwIfNotEmpty();
        InputStream is = null;
        File file = null;
        try {
            MultiPartRequestWrapper mpr = ActionContext.getMultiPartRequest();
            if (mpr == null) {
                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(this.getUploadMaxSize()) + " - system wide)";
                return "uploadFailed";
            }
            try {
                String toEncoding;
                String fromEncoding = CmsPropertyHandler.getUploadFromEncoding();
                if (fromEncoding == null) {
                    fromEncoding = "iso-8859-1";
                }
                if ((toEncoding = CmsPropertyHandler.getUploadToEncoding()) == null) {
                    toEncoding = "utf-8";
                }
                this.digitalAssetKey = new String(this.digitalAssetKey.getBytes(fromEncoding), toEncoding);
                DigitalAssetVO digitalAssetVO = ContentVersionController.getContentVersionController().checkStateAndChangeIfNeeded(this.contentVersionId, this.digitalAssetId, this.getInfoGluePrincipal());
                digitalAssetVO.setAssetKey(this.digitalAssetKey);
                if (mpr != null) {
                    Enumeration names = mpr.getFileNames();
                    while (names.hasMoreElements()) {
                        String fileSystemName;
                        String name = (String)names.nextElement();
                        file = mpr.getFile(name);
                        if (file == null) continue;
                        String contentType = mpr.getContentType(name);
                        String fileName = fileSystemName = mpr.getFilesystemName(name);
                        fileName = new VisualFormatter().replaceNonAscii(fileName, '_');
                        String tempFileName = "tmp_" + System.currentTimeMillis() + "_" + fileName;
                        String filePath = CmsPropertyHandler.getDigitalAssetPath();
                        fileSystemName = String.valueOf(filePath) + File.separator + tempFileName;
                        digitalAssetVO.setAssetContentType(contentType);
                        digitalAssetVO.setAssetFileName(fileName);
                        digitalAssetVO.setAssetFilePath(filePath);
                        digitalAssetVO.setAssetFileSize(new Integer(new Long(file.length()).intValue()));
                        is = new FileInputStream(file);
                        String fileUploadMaximumSize = this.getPrincipalPropertyValue("fileUploadMaximumSize", false, true);
                        logger.info((Object)("fileUploadMaximumSize:" + fileUploadMaximumSize));
                        if (!fileUploadMaximumSize.equalsIgnoreCase("-1") && new Integer(fileUploadMaximumSize) < new Long(file.length()).intValue()) {
                            file.delete();
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                            this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(fileUploadMaximumSize) + ")";
                            return "uploadFailed";
                        }
                        if (this.contentTypeDefinitionId == null || this.digitalAssetKey == null) continue;
                        this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(this.contentTypeDefinitionId);
                        AssetKeyDefinition assetKeyDefinition = ContentTypeDefinitionController.getController().getDefinedAssetKey(this.contentTypeDefinitionVO.getSchemaValue(), this.digitalAssetKey);
                        if (assetKeyDefinition == null) continue;
                        if (assetKeyDefinition.getMaximumSize() < new Long(file.length()).intValue()) {
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                            this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(assetKeyDefinition.getMaximumSize()) + ")";
                            return "uploadFailed";
                        }
                        if (!assetKeyDefinition.getAllowedContentTypes().startsWith("image")) continue;
                        if (!contentType.startsWith("image")) {
                            file.delete();
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnTypeNotImageText";
                            return "uploadFailed";
                        }
                        BufferedImage image = ImageIO.read(file);
                        int width = ((Image)image).getWidth(null);
                        int height = ((Image)image).getHeight(null);
                        String allowedWidth = assetKeyDefinition.getImageWidth();
                        String allowedHeight = assetKeyDefinition.getImageHeight();
                        if (!allowedWidth.equals("*")) {
                            Integer allowedWidthNumber = new Integer(allowedWidth.substring(1));
                            if (allowedWidth.startsWith("<") && width >= allowedWidthNumber) {
                                file.delete();
                                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToWideText";
                                return "uploadFailed";
                            }
                            if (allowedWidth.startsWith(">") && width <= allowedWidthNumber) {
                                file.delete();
                                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotWideEnoughText";
                                return "uploadFailed";
                            }
                            if (!allowedWidth.startsWith(">") && !allowedWidth.startsWith("<") && width != new Integer(allowedWidth)) {
                                file.delete();
                                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongWidthText";
                                return "uploadFailed";
                            }
                        }
                        if (allowedHeight.equals("*")) continue;
                        Integer allowedHeightNumber = new Integer(allowedHeight.substring(1));
                        if (allowedHeight.startsWith("<") && height >= allowedHeightNumber) {
                            file.delete();
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToHighText";
                            return "uploadFailed";
                        }
                        if (allowedHeight.startsWith(">") && height <= allowedHeightNumber) {
                            file.delete();
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotHighEnoughText";
                            return "uploadFailed";
                        }
                        if (allowedHeight.startsWith(">") || allowedHeight.startsWith("<") || height == new Integer(allowedHeight)) continue;
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongHeightText";
                        return "uploadFailed";
                    }
                } else {
                    logger.error((Object)"File upload failed for some reason.");
                }
                this.updatedDigitalAssetVO = DigitalAssetController.update(digitalAssetVO, is);
                this.isUpdated = true;
                return "success";
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to upload a new asset:" + e.getMessage()), (Throwable)e);
            }
            return "success";
        }
        finally {
            try {
                is.close();
                file.delete();
            }
            catch (Exception exception) {}
        }
    }

    public String getDigitalAssetUrl() throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(this.updatedDigitalAssetVO.getDigitalAssetId());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
        }
        return imageHref;
    }

    public String getAssetThumbnailUrl() {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(this.updatedDigitalAssetVO.getDigitalAssetId());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
        }
        return imageHref;
    }

    public Integer getDigitalAssetId() {
        return this.digitalAssetId;
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }

    public String getDigitalAssetKey() {
        return this.digitalAssetKey;
    }

    public boolean getIsUpdated() {
        return this.isUpdated;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public String getReasonKey() {
        return this.reasonKey;
    }

    public String getCloseOnLoad() {
        return this.closeOnLoad;
    }

    public void setCloseOnLoad(String closeOnLoad) {
        this.closeOnLoad = closeOnLoad;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public String getUploadErrorMaxSize() {
        return this.uploadMaxSize;
    }
}

