/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.infoglue.cms.applications.contenttool.actions.ViewContentVersionAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UpdateContentVersionAttributeAction
extends ViewContentVersionAction {
    private static final Logger logger = Logger.getLogger((String)UpdateContentVersionAttributeAction.class.getName());
    private static final long serialVersionUID = 1L;
    private ContentVersionVO contentVersionVO;
    private Integer contentId;
    private Integer languageId;
    private Integer contentVersionId;
    private String attributeName;
    private String deliverContext = "infoglueDeliverWorking";
    private ConstraintExceptionBuffer ceb;
    private static Boolean active = new Boolean(false);

    public UpdateContentVersionAttributeAction() {
        this(new ContentVersionVO());
    }

    public UpdateContentVersionAttributeAction(ContentVersionVO contentVersionVO) {
        this.contentVersionVO = contentVersionVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        logger.info((Object)"Updating content version attribute....");
        logger.info((Object)("contentId:" + this.contentId));
        logger.info((Object)("languageId:" + this.languageId));
        logger.info((Object)("attributeName:" + this.attributeName));
        super.initialize(this.contentVersionId, this.contentId, this.languageId);
        this.contentVersionVO = this.getContentVersionVO();
        String attributeValue = this.getRequest().getParameter(this.attributeName);
        logger.info((Object)("attributeValue:" + attributeValue));
        if (attributeValue != null) {
            this.setAttributeValue(this.contentVersionVO, this.attributeName, attributeValue);
            this.ceb.throwIfNotEmpty();
            this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
            ContentVersionController.getContentVersionController().update(this.contentId, this.languageId, this.contentVersionVO, this.getInfoGluePrincipal());
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doSaveAndReturnValue() {
        while (active.booleanValue()) {
            logger.info((Object)"Waiting for previous thread..");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Boolean bl = active;
        synchronized (bl) {
            active = new Boolean(true);
        }
        try {
            try {
                logger.info((Object)"Updating content version attribute through ajax....");
                logger.info((Object)("contentId:" + this.contentId));
                logger.info((Object)("languageId:" + this.languageId));
                logger.info((Object)("attributeName:" + this.attributeName));
                super.initialize(this.contentVersionId, this.contentId, this.languageId);
                this.contentVersionVO = this.getContentVersionVO();
                if (this.contentVersionVO == null) {
                    ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
                    ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentVO.getContentTypeDefinitionId());
                    StringBuffer sb = new StringBuffer();
                    sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes>");
                    List contentTypeAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(contentTypeDefinitionVO.getSchemaValue());
                    for (ContentTypeAttribute contentTypeAttribute : contentTypeAttributes) {
                        String initialValue = contentTypeAttribute.getContentTypeAttribute("initialData").getContentTypeAttributeParameterValue().getValue("label");
                        if (initialValue == null || initialValue.trim().equals("")) {
                            initialValue = "State " + contentTypeAttribute.getName();
                        }
                        sb.append("<" + contentTypeAttribute.getName() + "><![CDATA[" + initialValue + "]]></" + contentTypeAttribute.getName() + ">");
                    }
                    sb.append("</attributes></article>");
                    ContentVersionVO contentVersionVO = new ContentVersionVO();
                    contentVersionVO.setVersionComment("Autocreated");
                    contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                    contentVersionVO.setVersionValue(sb.toString());
                    this.contentVersionVO = ContentVersionController.getContentVersionController().create(this.contentId, this.languageId, contentVersionVO, null);
                } else if (!this.contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                    ContentVersion contentVersion = ContentStateController.changeState(this.contentVersionVO.getContentVersionId(), ContentVersionVO.WORKING_STATE, "Edit on sight", false, null, this.getInfoGluePrincipal(), this.contentVersionVO.getContentId(), new ArrayList());
                    this.contentVersionId = contentVersion.getContentVersionId();
                    this.contentVersionVO = contentVersion.getValueObject();
                }
                String attributeValue = this.getRequest().getParameter(this.attributeName);
                logger.info((Object)"*************************************************");
                logger.info((Object)"** SAVING **");
                logger.info((Object)"*************************************************");
                logger.info((Object)("attributeValue real:" + attributeValue));
                logger.info((Object)"attributeValue comp: Mattias testar \u00e5\u00e4\u00f6 \u00c5\u00c4\u00d6:");
                if (attributeValue != null) {
                    String toEncoding;
                    String fromEncoding = CmsPropertyHandler.getUploadFromEncoding();
                    if (fromEncoding == null) {
                        fromEncoding = "iso-8859-1";
                    }
                    if ((toEncoding = CmsPropertyHandler.getUploadToEncoding()) == null) {
                        toEncoding = "utf-8";
                    }
                    if (attributeValue.indexOf("\u00e5") == -1 && attributeValue.indexOf("\u00e4") == -1 && attributeValue.indexOf("\u00f6") == -1 && attributeValue.indexOf("\u00c5") == -1 && attributeValue.indexOf("\u00c4") == -1 && attributeValue.indexOf("\u00d6") == -1) {
                        attributeValue = new String(attributeValue.getBytes(fromEncoding), toEncoding);
                    }
                    logger.info((Object)("\n\nattributeValue original:" + attributeValue));
                    attributeValue = this.parseInlineAssetReferences(attributeValue);
                    logger.info((Object)("attributeValue transformed:" + attributeValue + "\n\n"));
                    this.setAttributeValue(this.contentVersionVO, this.attributeName, attributeValue);
                    this.ceb.throwIfNotEmpty();
                    this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                    ContentVersionController.getContentVersionController().update(this.contentId, this.languageId, this.contentVersionVO, this.getInfoGluePrincipal());
                    logger.info((Object)"*************************************************");
                    attributeValue = this.parseAttributeForInlineEditing(attributeValue, true);
                }
                this.getResponse().setContentType("text/plain");
                this.getResponse().getWriter().println(attributeValue);
            }
            catch (Throwable t) {
                t.printStackTrace();
                Boolean bl2 = active;
                synchronized (bl2) {
                    active = new Boolean(false);
                }
                return "error";
            }
        }
        catch (Throwable throwable) {
            Boolean bl3 = active;
            synchronized (bl3) {
                active = new Boolean(false);
            }
            throw throwable;
        }
        Boolean bl4 = active;
        synchronized (bl4) {
            active = new Boolean(false);
        }
        return "none";
    }

    public String doGetAttributeValue() throws Exception {
        try {
            super.initialize(this.contentVersionId, this.contentId, this.languageId);
            this.contentVersionVO = this.getContentVersionVO();
            if (this.contentVersionVO == null) {
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
                ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentVO.getContentTypeDefinitionId());
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes>");
                List contentTypeAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(contentTypeDefinitionVO.getSchemaValue());
                for (ContentTypeAttribute contentTypeAttribute : contentTypeAttributes) {
                    String initialValue = contentTypeAttribute.getContentTypeAttribute("initialData").getContentTypeAttributeParameterValue().getValue("label");
                    if (initialValue == null || initialValue.trim().equals("")) {
                        initialValue = "State " + contentTypeAttribute.getName();
                    }
                    sb.append("<" + contentTypeAttribute.getName() + "><![CDATA[" + initialValue + "]]></" + contentTypeAttribute.getName() + ">");
                }
                sb.append("</attributes></article>");
                ContentVersionVO contentVersionVO = new ContentVersionVO();
                contentVersionVO.setVersionComment("Autocreated");
                contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                contentVersionVO.setVersionValue(sb.toString());
                this.contentVersionVO = ContentVersionController.getContentVersionController().create(this.contentId, this.languageId, contentVersionVO, null);
            }
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.contentVersionVO.getContentId());
            logger.info((Object)("protectedContentId:" + protectedContentId));
            if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.Write", protectedContentId.toString())) {
                ceb.add(new AccessConstraintException("Content.contentId", "1001"));
            }
            ceb.throwIfNotEmpty();
            String attributeValue = "";
            if (this.contentVersionVO != null) {
                attributeValue = ContentVersionController.getContentVersionController().getAttributeValue(this.contentVersionVO, this.attributeName, false);
            }
            logger.info((Object)("attributeValue before parse:" + attributeValue));
            attributeValue = this.parseAttributeForInlineEditing(attributeValue, false);
            logger.info((Object)("attributeValue:" + attributeValue));
            this.getResponse().setContentType("text/plain");
            this.getResponse().getWriter().println(attributeValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return "none";
    }

    private String parseInlineAssetReferences(String attributeValue) throws Exception {
        HashMap<String, String> replacements = new HashMap<String, String>();
        logger.info((Object)"********************\n\n");
        Pattern pattern = Pattern.compile("\"DownloadAsset.action.*?\"");
        Matcher matcher = pattern.matcher(attributeValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Found a inline asset: " + match));
            String parsedContentId = match.substring(match.indexOf("contentId=") + 10, match.indexOf("&", 10));
            logger.info((Object)("parsedContentId: " + parsedContentId));
            int langStartIndex = match.indexOf("languageId=") + 11;
            String parsedLanguageId = match.substring(langStartIndex, match.indexOf("&", langStartIndex));
            logger.info((Object)("parsedLanguageId: " + parsedLanguageId));
            int assetStartIndex = match.indexOf("assetKey=") + 9;
            String parsedAssetKey = match.substring(assetStartIndex, match.indexOf("\"", assetStartIndex));
            logger.info((Object)("parsedAssetKey: " + parsedAssetKey));
            String url = "$templateLogic.getInlineAssetUrl(" + parsedContentId + ", \"" + parsedAssetKey + "\")";
            logger.info((Object)("url:" + url));
            replacements.put(match.substring(1, match.length() - 1), url);
        }
        logger.info((Object)"********************\n\n");
        for (String patternToReplace : replacements.keySet()) {
            String replacement = (String)replacements.get(patternToReplace);
            logger.info((Object)("Replacing " + patternToReplace + " with " + replacement));
            patternToReplace = patternToReplace.replaceAll("\\?", "\\\\?");
            logger.info((Object)("patternToReplace " + patternToReplace));
            replacement = replacement.replaceAll("\\$", "\\\\\\$");
            logger.info((Object)("replacement " + replacement));
            replacement = replacement.replaceAll("\\.", "\\\\.");
            logger.info((Object)("replacement " + replacement));
            replacement = replacement.replaceAll("\\(", "\\\\(");
            logger.info((Object)("replacement " + replacement));
            replacement = replacement.replaceAll("\\)", "\\\\)");
            logger.info((Object)("replacement " + replacement));
            logger.info((Object)("attributeValue before " + attributeValue));
            attributeValue = attributeValue.replaceAll(patternToReplace, replacement);
            logger.info((Object)("attributeValue after " + attributeValue));
        }
        return attributeValue;
    }

    private String parseAttributeForInlineEditing(String attributeValue, boolean checkPageReferences) throws Exception {
        String match;
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (checkPageReferences) {
            Pattern pattern = Pattern.compile("\\$templateLogic\\.getPageUrl\\(.*?\\)");
            Matcher matcher = pattern.matcher(attributeValue);
            while (matcher.find()) {
                String siteNodeIdString;
                match = matcher.group();
                logger.info((Object)("Adding match to registry after some processing: " + match));
                int siteNodeStartIndex = match.indexOf("(");
                int siteNodeEndIndex = match.indexOf(",");
                if (siteNodeStartIndex <= 0 || siteNodeEndIndex <= 0 || siteNodeEndIndex <= siteNodeStartIndex || (siteNodeIdString = match.substring(siteNodeStartIndex + 1, siteNodeEndIndex)).indexOf("templateLogic.siteNodeId") != -1) continue;
                Integer siteNodeId = new Integer(siteNodeIdString);
                logger.info((Object)("siteNodeId:" + siteNodeId));
                String parsedContentId = match.substring(match.lastIndexOf(",") + 1, match.lastIndexOf(")")).trim();
                String url = String.valueOf(this.getDeliverContext()) + "/ViewPage!renderDecoratedPage.action?siteNodeId=" + siteNodeId + "&languageId=" + this.languageId + "&contentId=" + parsedContentId;
                logger.info((Object)("url:" + url));
                replacements.put(match, url);
            }
        }
        Pattern assetPattern = Pattern.compile("\\$templateLogic\\.getInlineAssetUrl\\(.*?\\)");
        Matcher assetMatcher = assetPattern.matcher(attributeValue);
        while (assetMatcher.find()) {
            match = assetMatcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int contentStartIndex = match.indexOf("(");
            int contentEndIndex = match.indexOf(",");
            if (contentStartIndex <= 0 || contentEndIndex <= 0 || contentEndIndex <= contentStartIndex) continue;
            String contentIdString = match.substring(contentStartIndex + 1, contentEndIndex);
            this.contentId = new Integer(contentIdString);
            logger.info((Object)("contentId:" + this.contentId));
            String parsedAssetKey = match.substring(match.lastIndexOf(",") + 1, match.lastIndexOf(")")).trim();
            parsedAssetKey = parsedAssetKey.replaceAll("\"", "");
            String url = "DownloadAsset.action?contentId=" + this.contentId + "&languageId=" + this.languageId + "&assetKey=" + parsedAssetKey;
            logger.info((Object)("url:" + url));
            replacements.put(match, url);
        }
        for (String patternToReplace : replacements.keySet()) {
            String replacement = (String)replacements.get(patternToReplace);
            logger.info((Object)("Replacing " + patternToReplace + " with " + replacement));
            patternToReplace = patternToReplace.replaceAll("\\$", "\\\\\\$");
            logger.info((Object)("patternToReplace " + patternToReplace));
            patternToReplace = patternToReplace.replaceAll("\\.", "\\\\.");
            logger.info((Object)("patternToReplace " + patternToReplace));
            patternToReplace = patternToReplace.replaceAll("\\(", "\\\\(");
            logger.info((Object)("patternToReplace " + patternToReplace));
            patternToReplace = patternToReplace.replaceAll("\\)", "\\\\)");
            logger.info((Object)("patternToReplace " + patternToReplace));
            patternToReplace = patternToReplace.replaceAll("\\+", "\\\\+");
            logger.info((Object)("patternToReplace " + patternToReplace));
            logger.info((Object)("attributeValue before " + attributeValue));
            attributeValue = attributeValue.replaceAll(patternToReplace, replacement);
            logger.info((Object)("attributeValue after " + attributeValue));
        }
        return attributeValue;
    }

    private void setAttributeValue(ContentVersionVO contentVersionVO, String attributeName, String attributeValue) {
        String value = "";
        if (this.contentVersionVO != null) {
            try {
                logger.info((Object)("VersionValue:" + this.contentVersionVO.getVersionValue()));
                InputSource inputSource = new InputSource(new StringReader(this.contentVersionVO.getVersionValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node n = nl.item(0);
                nl = n.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName)) {
                        logger.info((Object)("Setting attributeValue: " + attributeValue));
                        Node valueNode = n.getFirstChild();
                        n.getFirstChild().setNodeValue(attributeValue);
                        break;
                    }
                    ++i;
                }
                contentVersionVO.setVersionValue(XMLHelper.serializeDom(document, new StringBuffer()).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionVO.setContentVersionId(contentVersionId);
    }

    public Integer getContentVersionId() {
        return this.contentVersionVO.getContentVersionId();
    }

    public void setStateId(Integer stateId) {
        this.contentVersionVO.setStateId(stateId);
    }

    public Integer getStateId() {
        return this.contentVersionVO.getStateId();
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getVersionValue() {
        return this.contentVersionVO.getVersionValue();
    }

    public void setVersionValue(String versionValue) {
        this.contentVersionVO.setVersionValue(versionValue);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getDeliverContext() {
        return this.deliverContext;
    }

    public void setDeliverContext(String deliverContext) {
        this.deliverContext = deliverContext;
    }
}

